
#define SAMPLE_RATE    150000
#include "mbed.h"
#include "adc.h"
#include "EthernetNetIf.h"
#include "UDPSocket.h"

EthernetNetIf eth( IpAddr(192,168,1,5), //IP Address
    IpAddr(255,255,255,0), //Network Mask
    IpAddr(192,168,1,254), //Gateway
    IpAddr(192,168,1,254)  //DNS
    );
//EthernetNetIf eth;
UDPSocket udp;

DigitalOut int_led(LED1);
DigitalOut P15(p15);
Serial pc(USBTX,USBRX);
Host multicast(IpAddr(192,168,1,10),27200, NULL);   //Target IP and port
ADC adc(SAMPLE_RATE, 1);
Ticker flipper;
unsigned short s1,s2,s3;
unsigned short i1,i2,i3;
unsigned short a1,a2,a3;
unsigned short sm1, sm2, sm3;
unsigned short im1, im2, im3;
unsigned short am1;
unsigned short smag, imag;
float s0;
//int k=0;
//Timer tmr;
Timeout timeout;
char str[50];
unsigned char buf[10];
int count_puls;
int led1_on = 0;
void Timer_Handler() 
{
    if(count_puls) {
        printf("cp %d\n", count_puls);
        count_puls--;
        led1_on = !led1_on;
        int_led = led1_on;
        P15 = !led1_on;
        timeout.attach_us(Timer_Handler, 100);
    } else
        timeout.detach();
}

void onUDPSocketEvent(UDPSocketEvent e) {  //Incoming UDP packet processing
    switch (e) {
        case UDPSOCKET_READABLE: //The only event for now
            char buf[64] = {0};
            Host host;
            while ( int len = udp.recvfrom( buf, 63, &host ) ) {
                if ( len <= 0 )
                    break;
                printf("From %d.%d.%d.%d: %s\n", host.getIp()[0], host.getIp()[1], host.getIp()[2], host.getIp()[3], buf);
            }
            switch(buf[0]) {
            case '1':
                count_puls = 8;
                break;
            case '2':
                count_puls = 4;
                break;
            case '3':
                count_puls = 6;
                break;
            case '4':
                count_puls = 2;
                break;
            case '5':
                count_puls = 10;
                break;
            default:
                count_puls = 0;
            }
            timeout.attach_us(Timer_Handler, 100);
            break;
    }
}
/*
 void adc_comlete(uint32_t value) {
    samples1 = adc.read(p20);
        Net::poll();                //Do network stuff
    sprintf(str, "1=%4u\0", samples1);
    printf("%d\n", samples1);
    udp.sendto( str, strlen(str)+1, &multicast );
    
 }
*/ 
unsigned short Major(unsigned short dadc2, unsigned short dadc0, unsigned short dadc1)
{
//printf("%d %d %d\n", dadc2, dadc0, dadc1);
    unsigned short rez;
    int dif01, dif02, dif12;
    dif01 = dadc0 - dadc1;
    dif02 = dadc0 - dadc2;
    dif12 = dadc1 - dadc2;
    if (dif01 < 0) dif01 = -dif01;
    if (dif02 < 0) dif02 = -dif02;
    if (dif12 < 0) dif12 = -dif12;
    if (dif01 < dif02) {
        if (dif12 < dif01)
            dadc0 = dadc2;
        //else // &#65533;&#65533;&#65533;&#65533;&#65533;&#65533;&#65533;&#65533; 2
    } else {
        if (dif12 < dif02)
            dadc0 = dadc2; // &#65533;&#65533;&#65533;&#65533;&#65533;&#65533;&#65533;&#65533; 0
        else
            dadc1 = dadc2; // &#65533;&#65533;&#65533;&#65533;&#65533;&#65533;&#65533;&#65533; 1
    }
    rez = dadc0 + dadc1;
    rez >>= 1;
    return rez;
}
int delta;
float err;
static int number = 0;

void flip() {                       // interrupt function: measurement and sending a UDP packet
    switch(number) {
    case 0:
        s1 = adc.read(p20);
        number++;
        break;
    case 3:
        s2 = adc.read(p20);
        number++;
        break;
    case 6:
        s3 = adc.read(p20);
        number++;
        sm1 =  Major(s1, s2, s3);
//        sprintf(str, "1=%4u\0",sm1);
//        Net::poll();                //Do network stuff
//        udp.sendto( str, strlen(str)+1, &multicast );
        break;
    case 1:
        number++;
        i1 = adc.read(p19);
        break;
    case 4:
        number++;
        i2 = adc.read(p19);
        break;
    case 7:
        number++;
        i3 = adc.read(p19);
        im1 =  Major(i1, i2, i3);
//        sprintf(str, "2=%4u %4u\0",sm1, im1);
//        Net::poll();                //Do network stuff
//        udp.sendto( str, strlen(str)+1, &multicast );
        break;
    case 2:
        number++;
        a1 = adc.read(p17);
        break;
    case 5:
        number++;
        a2 = adc.read(p17);
        break;
    case 8:
        number=0;
        a3 = adc.read(p17);
        am1 =  Major(a1, a2, a3);
        sprintf(str, "2=%4u %4u %4u\0",sm1, im1, am1);
        Net::poll();                //Do network stuff
        udp.sendto( str, strlen(str)+1, &multicast );
        break;
    }
}
/*
void flip() {                       // interrupt function: measurement and sending a UDP packet
//    int_led = !int_led;
//     adc.select(p19);
//    adc.burst(1);
//   adc.start();
//     wait_us(500);
//if(adc.done(p20)) {
    switch(number) {
    case 0:
        number++;
        s1 = adc.read(p20);
        break;
    case 1:
        number++;
        s2 = adc.read(p20);
        break;
    case 2:
        number++;
        s3 = adc.read(p20);
        m1 =  Major(s1, s2, s3);
        break;
    case 3:
        number++;
        s1 = adc.read(p20);
        break;
    case 4:
        number++;
        s2 = adc.read(p20);
        break;
    case 5:
        number++;
        s3 = adc.read(p20);
        m2 =  Major(s1, s2, s3);
        break;
    case 6:
        number++;
        s1 = adc.read(p20);
        break;
    case 7:
        number++;
        s2 = adc.read(p20);
        break;
    case 8:
        number=0;
        s3 = adc.read(p20);
        m3 =  Major(s1, s2, s3);
        mag =  Major(m1, m2, m3);
        Net::poll();                //Do network stuff
        sprintf(str, "1=%4u\0", mag);
//    printf("%d\n", samples4);
        udp.sendto( str, strlen(str)+1, &multicast );
        break;
    }
}
*/
#define MASK 0xC700000C
//#define MASK 0x00000000

int main() {
    pc.baud(57600);
    //Ethernet initializing, Serial Interface - 57600 kbit/s
    printf("Setting up...\n");
    P15 = 1;
    EthernetErr ethErr = eth.setup();
    if (ethErr) {
//        printf("Error %d in setup.\n", ethErr);
        return -1;
    }
//    printf("Setup OK\n");
 //   Host multicast(IpAddr(239, 192, 1, 100), 50000, NULL); //Join multicast group on port 50000
    AnalogIn in0(p20);
    AnalogIn in1(p19);
//    AnalogIn in2(p18);
    AnalogIn in3(p17);
//    AnalogIn in4(p16);
//    AnalogIn in5(p15);
//    PortOut(Port0, MASK);
//    DigitalOut P19(p19);
    AnalogOut tri(p18);
//    DigitalOut P17(p17);
    DigitalOut P16(p16);
    P16 = 0; // P17 = 0;// = P19 = 0;

    udp.setOnEvent(&onUDPSocketEvent);
    udp.bind(multicast);
    
    Net::poll();
    
//    tmr.start();

    //Turning ON Burst-mode ADC on pins 17,18,19,20  note: connect not used ADC ping to ground
//    adc.startmode(0,0);
    adc.burst(1);
     adc.setup(p20,1);
     adc.setup(p19,1);
//     adc.select(p20);
//     adc.start();
//    adc.setup(p18,1);
    adc.setup(p17,1);
//    printf("start\n");
//    printf("%d\n", adc.channel_to_pin_number(0));

    flipper.attach_us(&flip, 83); // Interrupt Turn ON (100 - 10kHz; 1000 - 1 kHz)
    tri = 0;
    while(1) {
        tri = tri + 0.001;
        wait_us(100);
        if(tri >= 0.06) {
            tri = 0;
        }
    }
}