#include "mbed.h"
#include <math.h>
#include "MedianFilter.h"

int comp(const void *a, const void *b)
{
    int *aa = (int*)a;
    int *bb = (int*)b;
    if(*aa < *bb)
        return 1;
    if(*aa == *bb)
        return 0;
    return -1;
}


void MedianFilter::NextHead()
{
    if(++Head == max_size)
        Head = 0;
}

MedianFilter::MedianFilter(int size)
{
    max_size = size;
    median_index = max_size / 2;
    Head = 0;
    for(int i=0; i<max_size; i++)
        val[i] = 0;
}

void MedianFilter::AddValue(int value)
{
    val[Head] = value;
    NextHead();
}

typedef int* IPTR;

void MedianFilter::Copy()
{
    for(int i=0; i<max_size; i++) {
        sort_val[i] = val[i];
    }
 //   Sort();
    qsort((void*)sort_val, (size_t)max_size, sizeof(IPTR), comp);
}
/*
void MedianFilter::Sort() 
{
    for(int l=max_size-1; l>=0; l--)
    for(int i=l; i<max_size-1; i++)
        if(sort_val[i] > sort_val[i+1]) {
            int tmp = sort_val[i];
            sort_val[i] = sort_val[i+1];
            sort_val[i+1] = tmp;
        }
}
*/
int MedianFilter::GetMedian(int v)
{
    AddValue(v);
    Copy();
    unsigned short med = sort_val[median_index];
    if(abs(v - med) > 50)
        return med;
    else
        return v;
}
