#define SAMPLE_RATE    50000
#include "mbed.h"
#include "adc.h"
#include "EthernetNetIf.h"
#include "UDPSocket.h"
#include "MedianFilter.h"
struct {
    char key;
    unsigned short v1;
    unsigned short v2;
    unsigned short v3;
    unsigned short v4;
} buff;


EthernetNetIf eth( IpAddr(192,168,1,155), //IP Address
    IpAddr(255,255,255,0), //Network Mask
    IpAddr(192,168,1,254), //Gateway
    IpAddr(192,168,1,254)  //DNS
    );
//EthernetNetIf eth;
UDPSocket udp;

DigitalOut int_led1(LED1);
DigitalOut int_led2(LED2);
DigitalOut int_led3(LED3);
DigitalOut int_led4(LED4);
//DigitalOut P21(p21);
//DigitalOut P22(p22);
//DigitalOut P23(p23);
//DigitalOut P24(p24);
//Serial pc(USBTX,USBRX);
Host multicast(IpAddr(192,168,1,51),27200, NULL);   //Target IP and port
ADC adc(SAMPLE_RATE, 1);
Ticker flipper;
unsigned short s1,s2,s3;
unsigned short i1,i2,i3;
unsigned short a1,a2,a3;
unsigned short b1,b2,b3;
unsigned short bm1;
unsigned short sm1, sm2, sm3;
unsigned short im1, im2, im3;
unsigned short am1, am2, am3;
unsigned short smag, imag, amag;
float s0;

MedianFilter mf16(9);
MedianFilter mf17(9);
MedianFilter mf19(9);
MedianFilter mf20(9);
void flip();
/////////////////////////////////////////
DigitalInOut port_in_out[4] = {DigitalInOut(p21),DigitalInOut(p22),DigitalInOut(p23),DigitalInOut(p24)};
//DigitalInOut P21(p21);
//DigitalInOut P22(p22);
//DigitalInOut P23(p23);
//DigitalInOut P24(p24);
int count_puls;
int mode_read;
int device_no;
Timeout timeout;
Timeout timeout2;
InterruptIn port_interrupt[4] = {InterruptIn(p21),InterruptIn(p22),InterruptIn(p23),InterruptIn(p24)};
//InterruptIn impuls21(p21);
//InterruptIn impuls22(p22);
//InterruptIn impuls23(p23);
//InterruptIn impuls24(p24);
int count_imp = 0;
void impuls_fall() {count_imp++;}
/////////////////////////////////////////
unsigned char send_buf[16];

void Handler21() {
}

void Timer_Handler21() {
    send_buf[0] = '5';
    send_buf[2] = device_no - 1;
    switch(count_imp) {
        case 0:
            send_buf[1] = 0;
            break;
        case 1:
            send_buf[1] = 1;
            break;
        case 2:
            send_buf[1] = 3;
            break;
        case 3:
            send_buf[1] = 4;
            break;
        case 4:
            send_buf[1] = 2;
            break;
        case 5:
            send_buf[1] = 5;
            break;
    }
    Net::poll();                //Do network stuff
    udp.sendto((char*)&send_buf, 3, &multicast );
    timeout2.detach();
//    pc.printf("%d  %s\n", count_imp, (char*)&send_buf);
}


void Timer_Handler() 
{
    if(count_puls) {
        unsigned char v = count_puls % 2;
        count_puls--;
//        led1_on = !led1_on;
//        int_led1 = led1_on;
        port_in_out[device_no-1] = v;
/*        switch(device_no) {
        case 1:
            P21 = v;
            break;
        case 2:
            P22 = v;
            break;
        case 3:
            P23 = v;
            break;
        case 4:
            P24 = v;
            break;
        default:
            timeout.detach();
            return;    
        }
*/        
        if(mode_read) {
            timeout.attach_us(Timer_Handler, 30000);
            mode_read = 0;
            int_led1 = 1;

        } else {
            timeout.attach_us(Timer_Handler, 1000);
            int_led1 = 0;
        }
    } else {
        timeout.detach();
        port_in_out[device_no-1].input();
        timeout2.attach_us(Timer_Handler21, 200000);
        count_imp = 0;

    }
}
bool transmit_enable = false;
void StartTransmit(bool start) {
    if(start) {
        transmit_enable = true;
//        flipper.attach_us(&flip, 200); // Interrupt Turn ON (100 - 10kHz; 1000 - 1 kHz)
    } else {
        transmit_enable = false;
//        flipper.detach();
//        flipper.attach_us(&flip, 200000); // Interrupt Turn ON (100 - 10kHz; 1000 - 1 kHz)
    }
}

void onUDPSocketEvent(UDPSocketEvent e) {  //Incoming UDP packet processing
    int len;
    switch (e) {
        case UDPSOCKET_READABLE: //The only event for now
            char buf[64] = {0};
            Host host;
            while ( len = udp.recvfrom( buf, 63, &host ), len ) {
                if ( len <= 0 )
                    break;
      //          printf("From %d.%d.%d.%d: %s\n", host.getIp()[0], host.getIp()[1], host.getIp()[2], host.getIp()[3], buf);
            }
            switch(buf[0]) {
            case 'S':
                StartTransmit(true);
                return;        
            case 's':
                StartTransmit(false);
                return;
            case '1':
                device_no = 1;
//                int_led1 = 1;
                break;
            case '2':
                device_no = 2;
//                int_led2 = 1;
                break;
            case '3':
                device_no = 3;
//                int_led3 = 1;
                break;
            case '4':
                device_no = 4;
//                int_led3 = 1;
                break;
            default:
                device_no = 0;
//                int_led4 = 1;
                count_puls = 0;
                return;
            }
                int_led1 = 0;
                int_led2 = 0;
                int_led3 = 0;
                int_led4 = 0;
            if(buf[2] == 0) {
                mode_read = 0;
                switch(buf[1]) {
                case '1':
                    count_puls = 2; //8
     //               int_led1 = 1;
                    break;
                case '2':
                    count_puls = 8; //4;
     //               int_led2 = 1;
                    break;
                case '3':
                    count_puls = 4; //6;
     //               int_led3 = 1;
                    break;
                case '4':
                    count_puls = 6; //2;8
     //                int_led4 = 1;
                   break;
                case '5':
                    count_puls = 10;
     //                int_led1 = 1;
     //                 int_led2 = 1;
                 break;
                default:
                    count_puls = 0;
                 }
            } else {
              count_puls = 2;
                mode_read = 1;
                
//                led1_on = 1;
            }
            port_in_out[device_no-1].output();
             timeout.attach_us(Timer_Handler, 1000);
           break;
    }
}



//static int number20 = 0;
//static int pass20 = 0;
int ccc = 0;
int number = 0;
int complete20 = 1;
int d20 = 0;
void adc_comlete20(uint32_t value) {
//    if(++d20 == 10000)
//                int_led1 = 1;
//    if(d20 == 20000) {
//                int_led1 = 0;
//                d20 = 0;
//    }
       s1 = adc.read(p20);
       sm1 = mf20.GetMedian(s1);
//       adc.interrupt_state(p20, 0);
       complete20 = 1;
        adc.interrupt_state(p20, 0);
//        adc.select(p16);
         adc.interrupt_state(p16, 1);
 }

 
int d19 = 0;
//static int number19 = 0;
int complete19 = 1;
//static int pass19 = 0;
void adc_comlete19(uint32_t value) {
//    if(++d19 == 10000)
//                int_led2 = 1;
//    if(d19 == 20000) {
//                int_led2 = 0;
//                d19 = 0;
//    }
        i1 = adc.read(p19);
        im1 = mf19.GetMedian(i1);
        complete19 = 1;
         adc.interrupt_state(p19, 0);
 //       adc.select(p20);
         adc.interrupt_state(p20, 1);
}

int complete17 = 1;
int d17 = 0;
void adc_comlete17(uint32_t value) {
//    if(++d17 == 10000)
//                int_led3 = 1;
//    if(d17 == 20000) {
//                int_led3 = 0;
//                d17 = 0;
//    }
        b1 = adc.read(p17);
        bm1 = mf17.GetMedian(b1);
        complete17 = 1;
        adc.interrupt_state(p17, 0);
 //       adc.select(p19);
         adc.interrupt_state(p19, 1);
 }

int d16 = 0;
//static int number16 = 0;
int complete16 = 1;
//int pass16 = 0;
void adc_comlete16(uint32_t value) {
//    if(++d16 == 10000)
//                int_led4 = 1;
//    if(d16 == 20000) {
//                int_led4 = 0;
//                d16 = 0;
//    }
        a1 = adc.read(p16);
        am1 = mf16.GetMedian(a1);
        complete16 = 1;
        adc.interrupt_state(p16, 0);
//        adc.select(p17);
         adc.interrupt_state(p17, 1);
}
 
int delta;
float err;

void flip() {
//if(!complete20)
//    int_led4 = 1;
//    if(complete20 && complete19 && complete16) {
  {      //complete20 = complete19 = 
  complete16 = 0;
 //       int_led4 = 1;
 //       sprintf(str, "2=%4u %4u %4u\0",a1, im1, a1);
 //       printf(str);
    buff.key = '2';
    buff.v1 = sm1;
    buff.v2 = im1;
    buff.v3 = am1;
    buff.v4 = bm1;
        Net::poll();                //Do network stuff
        if(transmit_enable)
            udp.sendto((char*)&buff, sizeof(buff), &multicast );
 //       udp.sendto( str, strlen(str)+1, &multicast );
//        LPC_ADC->ADINTEN = 0;
//        adc.interrupt_state(p20, 1);
//        adc.interrupt_state(p19, 1);
        adc.interrupt_state(p16, 1);
//            int_led4 = 0;
//        LPC_ADC->ADINTEN &= ~0x100;
//        LPC_ADC->ADINTEN |= 1 << chan;
//        LPC_ADC->ADINTEN |= 0x32;
        /* Enable the ADC Interrupt */
//        NVIC_EnableIRQ(ADC_IRQn);
    } 
//    else {
//            int_led4 = 0;
//    }
}

#define MASK 0xC700000C
//#define MASK 0x00000000

int main() {
//    pc.baud(57600);
    //Ethernet initializing, Serial Interface - 57600 kbit/s
//    printf("Setting up...\n");
    port_in_out[0].output();
    port_in_out[1].output();
    port_in_out[2].output();
    port_in_out[3].output();
    port_in_out[0]=1;
    port_in_out[1]=1;
    port_in_out[2]=1;
    port_in_out[3]=1;
    EthernetErr ethErr = eth.setup();
//    if (ethErr) {
//        printf("Error %d in setup.\n", ethErr);
//        return -1;
//    }
//    printf("Setup OK\n");
 //   Host multicast(IpAddr(239, 192, 1, 100), 50000, NULL); //Join multicast group on port 50000
    AnalogIn in0(p20);
    AnalogIn in1(p19);
    AnalogIn in2(p17);
    AnalogIn in3(p16);
//    PortOut(Port0, MASK);
//    DigitalOut P19(p19);
    AnalogOut tri(p18);
 //   DigitalOut P17(p17);
    DigitalOut P15(p15);
 //   P17 = 0;  
    P15 = 0;// = P19 = 0;
    port_interrupt[0].fall(&impuls_fall);
    port_interrupt[1].fall(&impuls_fall);
    port_interrupt[2].fall(&impuls_fall);
    port_interrupt[3].fall(&impuls_fall);

    udp.setOnEvent(&onUDPSocketEvent);
    udp.bind(multicast);
    
    Net::poll();
    
//    tmr.start();

    //Turning ON Burst-mode ADC on pins 17,18,19,20  note: connect not used ADC ping to ground
//    adc.startmode(0,0);
     adc.burst(1);
     adc.setup(p20,1);
     adc.setup(p19,1);
//     adc.select(p20);
//     adc.start();
    adc.setup(p17,1);
    adc.setup(p16,1);
//    printf("start\n");
//    printf("%d\n", adc.channel_to_pin_number(0));
//complete20 = complete19 = 
complete16 = 0;
    adc.append(p20, adc_comlete20);
    adc.interrupt_state(p20, 0);
    adc.append(p19, adc_comlete19);
    adc.interrupt_state(p19, 0);
    adc.append(p17, adc_comlete17);
    adc.interrupt_state(p17, 0);
    adc.append(p16, adc_comlete16);
    adc.interrupt_state(p16, 0);
    flipper.attach_us(&flip, 200); // Interrupt Turn ON (100 - 10kHz; 1000 - 1 kHz)
    tri = 0;
    while(1) {
        tri = tri + 0.001;
        wait_us(100);
        if(tri >= 0.06) {
            tri = 0;
        }
    }
}