/*CONFIGURACION MAESTRO
Mediante las palancas(1,2,3) seleccionamos el modo de comunicacion
La cuarta palanca sirve para hacer un or con 1 o 2 al uart
SPI y uart estan preparados para 10 segundos de demo mediante timer
SPI Maestro transmite la lectura del sensor de temperatura conectado a l pin 20
al equipo esclavo

*/
#include "mbed.h"
#include "TextLCD.h"
TextLCD lcd(p21, p22, p23, p24, p25, p26); // rs, rw, d4, d5, d6, d7
//------CONFIGURACION PINES DE TR/RE-----------------
SPI ser_port(p5, p6, p7); //mosi, miso, sclk
I2C i2c_port(p9, p10);//SDA,SCL
Serial async_port(p13, p14); //CAMBIADOS AL 13 Y 14///set up TX and RX on pins 28 and 27
//-------CONFIGURACION LEDS--------------------------------
DigitalOut red_led(p19); //red led
DigitalOut green_led(p28); //green led
DigitalOut strobe(p11); //a strobe to trigger the scope
DigitalOut cs(p12); //this acts as “slave select”
//----------------SELECT SPI----AL P8 DEL ESCLAVO
DigitalOut selec(p27);//para seleccionar CONECTAR AL PIN8 DEL ESCLAVO
//-------CONFIGURACION INTERRUPTORES
DigitalIn pulsa15(p15);//palanca PARA 1 o 2
InterruptIn buttonp16(p16);//palanca para modos de transmision
InterruptIn buttonp17(p17);
InterruptIn buttonp18(p18);
//---------VAARIABLE CONVERSION VOLTAJE
float milivolts;
//-----Entrada termometro
AnalogIn tem(p20);
//---------TIMER-------------------------
Timer t2; // define Timer with name “t”
//-------CARACTERES DE INTERCAMBIO
char switch_word ; //word we will send
char recd_val; //value return from slave
const int addr = 0x52; //the I2C slave address, an arbitrary even number <-- ojo con esto
//--------FUNCIONES------------------
void comprueba(){
     red_led=0; //preset both to 0
    green_led=0;
    lcd.cls();//limpiamos el charco
    recd_val=recd_val & 0x03; //AND out unwanted bits
    if (recd_val==1)
     {   red_led=1;
        lcd.printf("LLega %c \n\r",recd_val);
        wait(0.5);
        }//no debe de salir
    if (recd_val==2)
      {  green_led=1;
      lcd.printf("El valor enviado es 2");
      wait(0.5);}
    if (recd_val==3){
        red_led=1;
        green_led=1;
        lcd.printf("El valor enviado es 3");
        wait(0.5);
                }
    
    }
void i2cpP(){
     
     /*Remember, you will need a pull-up resistor on sda and scl.
All drivers on the I2C bus are required to be open collector, and 
so it is necessary for pull up resistors to be used on the two signals.  
A typical value for the pullup resistors is around 2.2k ohms, 
connected between the pin and 3v3. https://developer.mbed.org/handbook/I2C*/
     lcd.printf("Prueba i2cp");
        wait(2);
        lcd.cls();
        lcd.printf("COMIENZO ");
   //send a single byte of data, in correct I2C package
        i2c_port.start(); //force a start condition
        i2c_port.write(addr); //send the address
        i2c_port.write(switch_word); //send one byte of data, ie switch_word
        i2c_port.stop(); //force a stop condition
        wait(0.002);
        lcd.printf("POST WAIT");
        //receive a single byte of data, in correct I2C package 
        i2c_port.start();
        i2c_port.write(addr | 0x01); //send address, with R/W bit set to Read  <-- ojo con esto
        recd_val=i2c_port.read(addr); //Read and save the received byte
        i2c_port.stop(); //force a stop condition
        comprueba();
    
    
    }
void spiP(){
    lcd.printf("Prueba spi");
        wait(2);
        lcd.cls();
        t2.reset();// reseteamos el timer
        t2.start(); //start the timer
while(t2.read()<10)
{
   milivolts = (tem / 1023.0) * 500;// /5000*10
   cs = 0; //select slave
        ser_port.write(milivolts);
        cs = 1;
   }
   /*
    cs = 0; //select slave
    recd_val=ser_port.write(switch_word); //send switch_word and receive data
    cs = 1;
    wait(0.01);
    //set leds according to incoming word from slave
    
    */
  // comprueba();
   
    }
void uartP(){
    lcd.printf("Prueba uart");
        wait(2);
        lcd.cls();
    t2.reset();// reseteamos el timer
        t2.start(); //start the timer
while(t2.read()<10)
{
        strobe =1; //short strobe pulse
        wait_us(10);
        strobe=0;
        // lcd.printf("POST STROBE");
         wait(2);
        async_port.putc(switch_word); //transmit switch_word
        if (async_port.readable()==1) //is there a character to be read?
        recd_val=async_port.getc(); //if yes, then read it
        // lcd.printf("PRECOMPRUEBA");
          wait(2);
        comprueba();  
  // lcd.printf("POSTCOMPRUEBA");
          wait(2);
    }
    t2.stop();//paramos el timer
    }
    
int main() {
     lcd.printf("Prueba ");
    async_port.baud(9600); 
    while(1) {
        switch_word=0xa0; //set up a recognizable output pattern
    if (pulsa15==1)
        switch_word=switch_word | 0x01; //OR in lsb
    if (pulsa15==0)
        switch_word=switch_word | 0x02; //OR in next lsb
      buttonp16.rise(&i2cpP);
      buttonp17.rise(&spiP);
      buttonp18.rise(&uartP);   
        
    }
    
    
}