
/*CONFIGURACION SLAVE*
/*Remember, you will need a pull-up resistor on sda and scl.
All drivers on the I2C bus are required to be open collector, and 
so it is necessary for pull up resistors to be used on the two signals.  
A typical value for the pullup resistors is around 2.2k ohms, 
connected between the pin and 3v3. https://developer.mbed.org/handbook/I2C*/
#include "mbed.h"
#include "TextLCD.h"
TextLCD lcd(p21, p22, p23, p24, p25, p26); // rs, e, d4, d5, d6, d7
//------CONFIGURACION PINES DE TR/RE-----------------
SPISlave ser_port(p5, p6, p7, p8); //mosi, miso, sclk, ssel el p8 al digout del master
I2CSlave slave(p9, p10); //Configure I2C slave
Serial async_port(p13, p14); //set up TX and RX on pins 28 and 27
//-------CONFIGURACION LEDS--------------------------------
DigitalOut red_led(p19); //red led
DigitalOut green_led(p28); //green led OJO    
DigitalOut strobe(p11); //a strobe to trigger the scope
DigitalOut cs(p12); //this acts as “slave select”


//-------CONFIGURACION INTERRUPTORES
DigitalIn pulsa15(p15);//palanca PARA 1 o 2
InterruptIn buttonp16(p16);//palanca para modos de transmision i2c
InterruptIn buttonp17(p17); //spi
InterruptIn buttonp18(p18); //uart
//-------CARACTERES DE INTERCAMBIO
char switch_word ; //word we will send
char recd_val; //value return from slave
//---------VAARIABLE CONVERSION VOLTAJE
float milivolts;
//---------TIMER-------------------------
Timer t2; // define Timer with name “t”
//--------FUNCIONES------------------
void comprueba(){
     red_led=0; //preset both to 0
    green_led=0;
    lcd.cls();//limpiamos el charco
    recd_val=recd_val & 0x03; //AND out unwanted bits
    if (recd_val==1)
     {   red_led=1;
        lcd.printf("El valor  es 1");
        wait(0.5);
        }//no debe de salir
    if (recd_val==2)
      {  green_led=1;
      lcd.printf("El valor  es 2");
      wait(0.5);}
    if (recd_val==3){
        red_led=1;
        green_led=1;
        lcd.printf("El valor es 3");
        wait(0.5);
                }
    
    }
void i2cpP(){
     lcd.printf("Prueba i2cp");
        wait(2);
        lcd.cls();
  while(1){  
    slave.write(switch_word); //load up word to send
        //test for I2C, and act accordingly
        int i = slave.receive();
        if (i == 3)
            { 
            //slave is addressed, Master will write
             lcd.printf("entra en if"); 
      wait(2);
            recd_val= slave.read();
            comprueba();
            }
    }
    
    }
void spiP(){
    lcd.printf("Prueba spi");
        wait(2);
        lcd.cls();
        t2.reset();// reseteamos el timer
        t2.start(); //start the timer
while(t2.read()<10){
       if(ser_port.receive()){
            milivolts=ser_port.read();    
        }
        lcd.printf("%1.2f",milivolts);
        wait(0.05);
        lcd.cls(); 
        
        }
        /*
  while(1){  
    if(ser_port.receive()) { //test if data transfer has occurred
     lcd.printf("entra en if"); 
      wait(2);
            recd_val = ser_port.read(); // Read byte from master
            ser_port.reply(switch_word); // Make this the next reply
        comprueba();
        }
  */
    
    
    }
void uartP(){
    lcd.printf("Prueba uart");
        wait(2);
        lcd.cls();
        t2.reset();// reseteamos el timer
        t2.start(); //start the timer
while(t2.read()<10){ // le damos 10 segundos de prueba
        strobe =1; //short strobe pulse
        wait_us(10);
        strobe=0;
        async_port.putc(switch_word); //transmit switch_word
        if (async_port.readable()==1) //is there a character to be read?
        {recd_val=async_port.getc(); //if yes, then read it
        lcd.printf("entra en if"); 
        wait(1);
         lcd.printf("%c \n\r",recd_val);
          wait(1);
        comprueba(); }
        lcd.printf("Postcomprueba"); 
        wait(1);
         lcd.cls();
   
    }
    t2.stop();
    }
    
int main() {
    async_port.baud(9600); 
    slave.address(0x52);
    while(1) {
        switch_word=0xa0; //set up a recognizable output pattern
    if (pulsa15==1)
        switch_word=switch_word | 0x01; //OR in lsb
    if (pulsa15==0)
        switch_word=switch_word | 0x02; //OR in next lsb
        
      //preparados para acceder a los modos de comunicación  
      buttonp16.rise(&i2cpP);
      buttonp17.rise(&spiP);
      buttonp18.rise(&uartP);   
        
    }
     
    
    
    
}