#include "mbed.h"
#include "nRF5xGap.h" 
#include "InterruptManager.h"
#include "nrf_gpio.h"
 
DigitalOut greenLed(P0_21);
DigitalOut blueLed(P0_22);
DigitalOut redLed(P0_23);

#define LED_ON  0
#define LED_OFF 1

#define BTN_PRESSED 0 
#define BTN_RELEASED 1 

/*
void RTC1_IRQHandler(void)
{
    if(NRF_RTC1->EVENTS_COMPARE[0] != 0) {
        NRF_RTC1->EVENTS_COMPARE[0] = 0;
        
        NRF_RTC1->TASKS_CLEAR = 1;
    }
    
}
void rtc_handler(void)
{
    
}
*/

void GPIOTE_IRQHandler(void)
{
    // This handler will be run after wakeup from system ON (GPIO wakeup) 
    if(NRF_GPIOTE->EVENTS_PORT) 
    { 
        NRF_GPIOTE->EVENTS_PORT = 0; 
        blueLed = LED_ON;
        printf("P2 Premuto\r\n");
    } 
}

//int RTC1_PRESCALER = 0;
//int RTC1_CC0 = 100;

int main() {

    blueLed = LED_OFF;
    greenLed = LED_OFF;
    redLed = LED_OFF;

    printf("\r\nInit\r\n");

    //NRF_POWER->SYSTEMOFF=0;               //power ON
    
    //NRF_RTC1->INTENSET = RTC_INTENSET_COMPARE0_Msk;
    //NRF_RTC1->PRESCALER = RTC1_PRESCALER;
    //NRF_RTC1->CC[0] = RTC1_CC0;
    
    //NVIC_EnableIRQ(RTC1_IRQn);
    
    //InterruptManager::get()->add_handler(rtc_handler, RTC1_IRQn);

    // Configure BUTTON0 as a regular input 
    nrf_gpio_cfg_input(p16, NRF_GPIO_PIN_PULLUP); 
    
    // Configure BUTTON 2 with SENSE enabled so that CPU is enabled (exit System-On low power mode) when pressing Button 2 
    nrf_gpio_cfg_sense_input(p17, NRF_GPIO_PIN_PULLUP, NRF_GPIO_PIN_SENSE_LOW); 
    
    blueLed = LED_ON;

    NRF_GPIOTE->INTENSET = GPIOTE_INTENSET_PORT_Msk;
    NVIC_EnableIRQ(GPIOTE_IRQn);
    //InterruptManager::get()->add_handler(p1_handler, GPIOTE_IRQn);
    
    
    while(1) 
    {      
         // If BUTTON 1 is pressed.. 
         if(nrf_gpio_pin_read(p16) == BTN_PRESSED) 
         { 
            printf("P1 Premuto\r\n");
            blueLed = LED_OFF;
            // Enter CONSTLAT mode if desired, otherwise LOWPWR mode will be used (LOWPWR is recommended for most applications) 
            //NRF_POWER->TASKS_CONSTLAT = 1; 
              
            // Enter System ON sleep mode 
            __WFE(); 
            __SEV(); 
            __WFE(); 
        } 
    } 
}
