#include "mbed.h"
#include "nRF5xGap.h" 
 
#define DEMOBOARD       1
#if DEMOBOARD
    InterruptIn powerButtonOn(P0_17);
    InterruptIn powerButtonOff(P0_18);
    DigitalOut greenLed(P0_21);
    DigitalOut blueLed(P0_22);
    DigitalOut redLed(P0_23);
#else
    InterruptIn powerButton(P0_18);
    DigitalOut greenLed(P0_12);
    DigitalOut blueLed(P0_15);
    DigitalOut redLed(P0_16);
#endif

#if DEMOBOARD
    #define LED_ON  0
    #define LED_OFF 1
#else
    #define LED_ON  1
    #define LED_OFF 0
#endif

volatile uint8_t state = 255;
Ticker timer;
volatile uint8_t lastState = 0;

void powerButtonOnPressedCallback(void)
{
     //NRF_POWER->SYSTEMOFF=0;
     state= 1;
}

void powerButtonOffPressedCallback(void)
{
     //NRF_POWER->SYSTEMOFF=1;
     state= 11;
}
void cbToON()
{
    timer.detach();
    state = 2;
}

void cbToOFF()
{
    timer.detach();
    state = 12;
}

int main() {
    //set event button 
    powerButtonOn.fall(powerButtonOnPressedCallback);
    powerButtonOff.fall(powerButtonOffPressedCallback);

    blueLed = LED_OFF;
    greenLed = LED_OFF;
    redLed = LED_OFF;

    printf("\r\nInit\r\n");

    //NRF_POWER->SYSTEMOFF=0;               //power ON
    //sd_power_system_off();
    
    while(1) {
        if(lastState != state) {
            lastState = state;
            printf("STATO %d\r\n", state);
        }
        switch(state) {
            case 1:
                printf("Stato 1\r\n");
                blueLed = LED_ON;
                timer.attach(cbToON, 1.0);
                state = 255;
                break;
            case 2:
                printf("Stato 2\r\n");
                NRF_POWER->SYSTEMOFF=0;     //power ON
                state = 255;
                break;
            case 11:
                printf("Stato 11\r\n");
                blueLed = LED_OFF;
                timer.attach(cbToOFF, 1.0);
                state = 255;
                break;
            case 12:
                printf("Stato 12\r\n");
                NRF_POWER->SYSTEMOFF=1;   //power OFF
                break;
            case 255:
                break;
            default:
                break;                
        }
    }
}
