#include "mbed.h"   //libreria de mbed  lol XD
#include "Servo.h"  // libreria del servo, es para controlar el servo

Serial bt(PTE0, PTE1); // establese puentos que comunican con el bluethoot, establese una varialbe llamada "bt" para estos puertos
Serial pc(USBTX,USBRX); // comunicacion serial con la computadora 
PwmOut servo(PTA5);      // esptablece una variable Pwm llamada "servo"
PwmOut buzzer_valor(PTB1); //  establece una variable Pwm llamada "buzzer_valor"
PwmOut led_foto(PTC8);           //establece una variable pwm llamada "led"
AnalogIn fotoresistencia_valor(PTB3); //establece una variable Analogica llamada "fotoresistencia_valor", esta variable la resive la freedom, 
DigitalOut led_sensorm(PTC9);
DigitalIn pinLectura = (PTB0);       // Pin de lectura del sensor INPUTPIN
Timer timer;

int valorReedSwitch = 0;
DigitalIn reedSwitch(PTA13);

void f_SensorMovimiento()
{
    timer.start();
    while(timer <= 3)
    {
        led_sensorm = 1;
    }
    timer.stop();
    timer.reset(); 
    led_sensorm=0;   
}

void fotoresistencia()
{                            // funcion de la fotoresistencia
    float valor=fotoresistencia_valor.read();      // lee es lavor de la fotoresistencia y la asigna a una variable flotante llamada "valor"
    wait(.025);                                    // timer se .025s
    valor=((fotoresistencia_valor -(.039))*(-10)); // funcion que recorre los valores de la freedom       
    //valor=((1)-(valor));                          // nada
    if(valor<0)
    {                                    // si el valor es menor a cero  
        valor=0;                                        // iguala el valor a 0
    }                                               
    if(valor>1)
    {                                     //si el valor es mayor a cero                                      
        valor=1;                                        // iguala el valor a 1
    }
    led_foto=valor;                                         // enciende el led con una intencidad = al valor 
}      

 void buzzer()
 {                 // funcion del buzzer
    bt.printf("Alarma Activada\n\r");   //imprime un string como respuesta, ay comnicacion y la funcion esta siendo corrida
    buzzer_valor.period_ms(1); // set PWM period 
    timer.start();
    while(timer <= 5)
    {
        buzzer_valor = 0.5; //set duty cycle
        led_sensorm = 1;
        wait(0.3); //hold for beat period
        buzzer_valor = 0;
        led_sensorm = 0;
        wait(0.3);
    }
    timer.stop();
    timer.reset();
 }                              // termina la funcion

int main()
{                 // inicia el programa
 
    bt.baud(9600);       // establese la comunicacion serial entre la freedom y el bluethooth
    servo.period_ms(20); // esta linea asigna un periodo en milisegundos, este periodo es asignado para pode usar es servo 
    
    while(1)                // esta parte del programa se repite infinitamente 
    {
        if(bt.readable())    //establesco la conexion del bluethooth
        {
            char c = bt.getc();    //resive un caracter via bluethoth y lo asigna a una variable char
            
            bt.printf("%c\n\r",c); // como respuesta para verificar que la informacion mandada aya llegado a la freedom
                                    // la imprime en la terminal del usuario
            
            if (c == 'w')
            {       //checa si el caracter mandado por el usuario es una "w"
            
                servo.pulsewidth_us(1700);// move servo to 180° position
                bt.printf("serbou\n\r");   // imprime en la terminal del usuario un string"servoa"
          
            }
            if (c == 's')
            {                   //checa si el caracter mandado por el usuario es una "s"
            
                servo.pulsewidth_us(1000);//move servo to 0 degrees
                bt.printf("servob\n\r"); //imprime en la terminal del usuario un string "servob"
            }
            
            if( c == 'p')
            {//checa si el caracter mandado por el usuario es una "p"
                buzzer();          //manda llamar la funcion del buzzer
            }
            
            if( c == 'r')
            {//checa si el caracter mandado por el usuario es una "p"
                while(c != 'v')
                {
                    valorReedSwitch = reedSwitch.read();
                    if(valorReedSwitch == 1);
                        buzzer();
                }
            }
            
            if (c == 'm')
            {
             
                bt.printf("Iluminacion Automatica Activada\r");
                while(c != 'v')
                {
                    int val = pinLectura.read();
                    if (val == 0)
                    {
                        f_SensorMovimiento();
                    }
                    if(bt.readable()) 
                    {                   // reestablese la conexcion del bluethooth para solisitar o checar si se vumple la opcion para salir del while(c!=='v') 
                        c = bt.getc();  //resive un caracter via bluethoth y lo asigna a una variable 
                        led_sensorm = 0;        //apaga el led si se sale de este pedaso 
                    }
                }
                bt.printf("Iluminacion Automatica Desactivada");
            }
            
            if (c == 'a')
            {
                bt.printf("Sistema de Seguridad Activado\r");
                while(c != 'v')
                {
                    int val = pinLectura.read();
                    if (val == 0)
                    {
                        bt.printf("INTRUSO!");
                        while (c != 'e'){
                            buzzer();
                            if(bt.readable()) 
                            {                   // reestablese la conexcion del bluethooth para solisitar o checar si se vumple la opcion para salir del while(c!=='v') 
                                c = bt.getc();  //resive un caracter via bluethoth y lo asigna a una variable 
                                led_sensorm = 0;        //apaga el led si se sale de este pedaso 
                            }
                        }
                    }
                    if(bt.readable()) 
                    {                   // reestablese la conexcion del bluethooth para solisitar o checar si se vumple la opcion para salir del while(c!=='v') 
                        c = bt.getc();  //resive un caracter via bluethoth y lo asigna a una variable 
                        led_sensorm = 0;        //apaga el led si se sale de este pedaso 
                    }
                }
                bt.printf("Alarma Desactivada");
            }
            
            if(c =='f')
            {       // checa si el caracter mandado por el usuario es una "v"
                bt.printf("Fotoresistencia Activada\r");
                while(c != 'v')
                { // la siguiente parte del programa se va a repetir infinitamente hasta que c no sea igual a "v"
                    fotoresistencia(); //manda llamar la funcion de la resistencia
                    if(bt.readable())
                    { // reestablese la conexcion del bluethooth para solisitar o checar si se vumple la opcion para salir del while(c!=='v')
                        c = bt.getc(); //resive un caracter via bluethoth y lo asigna a una variable char
                        led_foto=0;       //apaga el led si se sale de este pedaso
                    }//comunicacion
                }//cierra el while( c!=v)
                bt.printf("fotoresistencia DESACTIVADA\n\r");  //imprime en la terminal que se desactivo la resistnecia
            }   //cierra  el if de(c=='f')
        }//cierra el if de la comunicacion
    }// cierra el while (1)
}// ciera el int main 