#include "mbed.h"
#include "Servo.h"

// Declaracion de las fotoresistencias
AnalogIn Fotoresistencia1(PTB1);
AnalogIn Fotoresistencia2(PTB2);

// Declaracion de la comunicacion serial
Serial pc(USBTX,USBRX);

// Declaracion del servo
PwmOut Servo(PTD4);

// Declaracion del motor DC
PwmOut motorPin(PTC1);

int main() 
{ // Inicializa el programa
    Servo.period_ms(20);    // Establece el periodo Pwm del servo            
    
    while(1)
    { // Inicializa un ciclo infinito
    
        motorPin = 1; // Se inicializa el motor DC
    
        // Asigna a valorFotoresistencia el valor obtenido del sensor    
        float valorFotoresistencia1 = Fotoresistencia1.read();
        float valorFotoresistencia2 = Fotoresistencia2.read();
        
        // Imprime para cuestiones de calibracion
        pc.printf("%f\t%f\n", valorFotoresistencia1, valorFotoresistencia2);
        wait(0.1); // Espera de 0.1 segundos
        
        while (valorFotoresistencia2 == 0.02 && valorFotoresistencia1 == 0.02)
        { // Mientras ambas fotoresistencias detecten blanco...
            Servo.pulsewidth_us(1800); // El servo se mantiene en su posicion inicial, hacia adelante
        }
        
        while (valorFotoresistencia2 = 0.02 && valorFotoresistencia1 == 0.01)
        { // Mientras una resistencia lea blanco y otra negro...
            int movimiento = 1800;           // Se declara una variable de nombre movimiento con un valor de 1500
            movimiento = movimiento + 35;    // A este valor se le agrega 35
            Servo.pulsewidth_us(movimiento); // El servo se mueve a la posicion que indique la variable movimiento
        {
        
        while (valorFotoresistencia 2 == 0.01 && valorFotoresistencia1 == 0.02)
        { // Mientras una resistencia lea negro y la otra blanco...
            int movimiento = 1800;           // Se declara una variable de nombre movimiento con un valor de 1500
            movimiento = movimiento - 35;    // A este valor se le resta 35
            Servo.pulsewidth_us(movimiento); // El servo se mueve a la posicion que indique la variable movimiento
        }
    }
}