#include "mbed.h"
Serial pc(USBTX, USBRX);

DigitalOut led = (PTC9);      // LED que comprueba movimiento
DigitalIn pinLectura = (PTB0);       // Pin de lectura del sensor INPUTPIN
Timer timer;
int begin, end;

PwmOut buzzer_valor(PTB2);

Serial bt(PTE0, PTE1);

void fBuzzer()
{ // funcion del buzzer
    bt.baud(9600);
    buzzer_valor.period_ms(1); // set PWM period
    bt.printf("INTRUSO!");
    while(1)
    {
        if(bt.readable())
        {
            //valorDIP = switchSistemaSeguridad.read();
            buzzer_valor = 0.5; //set duty cycle
            wait(0.3); //hold for beat period
            buzzer_valor = 0;
            wait(0.3);
            
            /*ledsPrincipales = 1; //set duty cycle
            wait(0.3); //hold for beat period
            ledsPrincipales = 0;
            wait(0.3);*/
            
            int blue = bt.getc();
            if (blue == 'd'){     
                bt.printf("Sistema Desactivado");
                return;
            }
        }            
    }
}

void f_SensorMovimiento()
{
    timer.start();
    while(timer <= 3)
    {
        led = 1;
    }
    timer.stop();
    timer.reset();
    
    int val2 = pinLectura.read();
    
    if(val2 == 0){
        f_SensorMovimiento();
    }
    
    else{
        led = 0;
        return;
    }
}

int main()
{
    bt.baud(9600);
    while(1)
    {
        
        int val = pinLectura.read();
        
        if(bt.readable()) //establesco la conexion del bluethooth 
        { 
            char c = bt.getc(); //resive un caracter via bluethoth y lo asigna a una variable 
            //bt.printf("%c\n\r", c);
            
            if(c == 's')
            {
                bt.printf("Sistema Activado");
                if(val == 0)
                {
                    fBuzzer();
                }
            }
            
            if (c == 'm')
            {
                bt.printf("Iluminacion Automatica Activada\r");
                while(c != 'v'){
        
                    if (val == 0)
                    {
                        f_SensorMovimiento();
                    }
                    if(bt.readable()) 
                    {                   // reestablese la conexcion del bluethooth para solisitar o checar si se vumple la opcion para salir del while(c!=='v') 
                        c = bt.getc();  //resive un caracter via bluethoth y lo asigna a una variable 
                        led = 0;        //apaga el led si se sale de este pedaso 
                    }
                }
                bt.printf("Iluminacion Automatica Desactivada");
            }
            if(c == 'p')
            {
                bt.printf("Prueba");
            }
        }
    }
}