// Laboratorio 4 - Multimetro y Timers
// Andrea Fernanda Coronado Guzman

#include "mbed.h"
#define TAMAÑO_ARREGLO 9 // Constante que define el tamaño del arreglo
 
AnalogIn Volt_Out(PTA1); // Declaración del Voltímetro
AnalogIn Volt_Ohmetro(PTA1); // Declaración del Óhmetro
Serial pc(USBTX, USBRX); // Declaración del puerto serial
Timer reloj; // Declaración de timer
DigitalIn boton_medicion(PTB1); // 0 = voltimetro; 1 = ohmetro
DigitalIn boton_resultado(PTB2); // Boton que calcula el promedio y despliega el resultado
 
float Volt_In; // Voltaje de entrada
float Leer_tiempo; // Variable que leera el tiempo
float Promedio; // Promedio de los voltajes en el arreglo
float Vout_val;
float Valor_resistencia; // Valor de la resistencia desconocida
float Arreglo_voltajes[]= {0}; // Inicialización en 0 de un arreglo que guardara los valores de voltaje cada segundo
 
float promedio_voltajes (float arreglo[TAMAÑO_ARREGLO]) // Función que calcula el promedio de los voltajes leidos y los guarda en el arreglo mediante un contador
{
    float suma_voltajes = 0; // Inicializamos en 0 la variable suma_voltajes que sumara los voltajes leidos por el timer
    for (int lugar_arreglo = 0; lugar_arreglo < TAMAÑO_ARREGLO; lugar_arreglo++) // Ciclo que cambia al siguiente lugar en Arreglo_voltajes
    { 
        suma_voltajes += Arreglo_voltajes[lugar_arreglo]; // Asigna a cada lugar del arreglo el voltaje leido
    }
    return suma_voltajes/TAMAÑO_ARREGLO; // Calcula el promedio de los voltajes en el arreglo y regresa el resultado
}
 
int main()
{        
    while(1) // Ciclo infinito
    {
        reloj.start(); // Inicialización del timer
        Vout_val = Volt_Out*5; // Una variable que tendra el valor del voltaje de salida y se multiplica por 5
        Leer_tiempo = reloj.read();
        if(Leer_tiempo > 0 && Leer_tiempo < 0.5 ) // Toma las muestras a 2 Hz
        {
            if(boton_medicion == 0 && boton_resultado == 1) // Si el boton_medicion esta en modo voltimetro y boton_resultado se presiona, calculael promedio de voltajes en ese instante
            {
                pc.printf("Modo: Voltimetro \n"); // Confirma en que modo esta el mutlimetro
                for (int posicion_arreglo = 0; posicion_arreglo < TAMAÑO_ARREGLO; posicion_arreglo++) // Ciclo que actualiza los voltajes en cada espacio del arreglo
                {
                    Arreglo_voltajes[posicion_arreglo] = Arreglo_voltajes[posicion_arreglo+1]; // Se suma a posicion_arreglo un 1 para el lugar siguiente en el arreglo
                    Volt_In = 9*((Volt_Out*51000)/18000); // Al voltaje de salida se multiplica por la suma de R1+R2 y se divide entre R1,se multiplica de nuevo por 5 por ser el voltaje con que alimentamos
                    Arreglo_voltajes[TAMAÑO_ARREGLO-1] = Volt_In; // Elmininamos el primer valor y lo sustituimos por el siguiente
                    reloj.reset(); //El timer se restablece para hacer de nuevo mediciones
                }
                Promedio = promedio_voltajes(Arreglo_voltajes); //Uso de la funcion promedio_voltajes para calcular el promedio de los voltajes en el arreglo
                pc.printf("El voltaje promedio es de %f \n", Promedio/9);
                
            }
            else
            {
                if(boton_medicion == 1 && boton_resultado == 1) // Si el boton_medicion esta en modo ohmetro y boton_resultado se presiona, calcula la resistencia desconocida en el circuito
                {
                    pc.printf("Modo: Ohmetro \n"); // Confirma en que modo esta el mutlimetro
                    Valor_resistencia = 1/(1/(Volt_Ohmetro*3.3/.176-560)-1/100);// Valor de la resistencia desconocida
                    pc.printf("El valor de la resistencia desconocida es de %f ohms", Valor_resistencia);
                    reloj.reset();
                }
            }
        }
    }
}