#include "mbed.h"
#include <iostream>

#define MAX_CLIENTES 10

/*-------------------------------------
    VARIABLES
  -------------------------------------*/
  
InterruptIn botton_entrada(PTD4);
DigitalIn botton_salida();
DigitalOut doPuerta(LED_BLUE);
DigitalOut interrupcionLED(LED_RED);
char Nombre_cliente;
bool reconocercliente;
bool imprimircliente;
int gclienteadentro = 0;
Timer TimerInterrupcion;

/*-------------------------------------
    VARIABLES GLOBALES
  -------------------------------------*/
  
DigitalOut Puertas(LED_BLUE);       // Led Azul representa puertas. Encendido = Puertas cerradas. Apagado = Puertas abiertas. Comienza encendido.
bool gbReconocerCliente = false;
bool gbImprimirClientes = false;
int giClientesAdentro = 0;
Timer gtCerrarPuertas;
Timer gtPrintDebounce;
 

/* ---------------------------------------
   PROTOTIPOS DE FUNCIONES
   ---------------------------------------*/

void fInterrupcion();
/*Función de Interrupción.
Solicita que se abran las puertas y se
reconozca al cliente.
Regresa:
    TRUE si se abrieron las puertas,
    FALSE en caso contrario.*/

void xfAbrirPuertas();
/*Función de Interrupción.
Solicita que se imprima una lista
de clientes dentro de la tienda.*/

void fReconocerCliente(string * _strpClienteActual);
//Solicita que se cierren las puertas y se salude al cliente.


void xfImprimirClientes();
/* Realiza reconocimiento de usuario.
Para esta simulación se solicita el nombre
por comunicación serial.
Argumento:
  _strpClienteActual - Guarda aquí el nombre.*/

void fCerrarPuertas();
//Imprime una lista de clientes.

void fImprimirClientes(const string * straCliente, int iNumClientes);

// Alumnos: Solo usen esto si ya comprendieron el concepto de namespace.
using namespace std;
 

/* ---------------------------------------
    MAIN
   ---------------------------------------*/

int main()
{
    InterruptIn xiClientePorEntrar(PTA13);
    InterruptIn xiImprimirClientes(PTD5);
 
    //Un arreglo es un apuntador con un espacio delimitado:
    string straCliente[MAX_CLIENTES];
 
    int iClienteActual = 0;
 
    Puertas = 0;
 
    //Le decimos a InterruptIn qué funciones llamar:
    xiClientePorEntrar.rise(&xfAbrirPuertas);
    xiImprimirClientes.rise(&xfImprimirClientes);
 
    while(1) {
        //Atender posible solicitud de reconocer a cliente:
        if(gbReconocerCliente) {
            fReconocerCliente(&straCliente[iClienteActual]);
            iClienteActual++;
            gbReconocerCliente = false;
        }
 
        //Cerramos las puertas si ya pasaron 5 segundos:
        if(gtCerrarPuertas.read() > 5.0f) {
            fCerrarPuertas();
            gtCerrarPuertas.stop();
            gtCerrarPuertas.reset();
        }
 
        // Atender posible solicitud de imprimir clientes:
        // En un OS o RTOS esto tendría proridada baja:
        if(gbImprimirClientes) {
            gtPrintDebounce.start();
            fImprimirClientes(straCliente, giClientesAdentro);
            gbImprimirClientes = false;
        }
 
 
        // Permitimos volver a imprimir la lista:
        if(gtPrintDebounce.read() > 2.0f) {
            gtPrintDebounce.stop();
            gtPrintDebounce.reset();
        }
    }
 
    return 0;
}

/*--------------------------------
    Funciones
  --------------------------------*/

void fInterrupcion(){
    int x;
    interrupcionLED =! interrupcionLED;
    TimerInterrupcion.start();
    x = TimerInterrupcion.read_ms();
    if(x == 1000) 
        interrupcionLED =!interrupcionLED;
}

void xfAbrirPuertas(){

    botton_entrada.rise(fInterrupcion);
    if(giClientesAdentro < MAX_CLIENTES && Puertas == 0) {
        Puertas = 1;
        gbReconocerCliente = true;
        gtCerrarPuertas.start();
        giClientesAdentro++;
    }
}

void fReconocerCliente(string *_strpClienteActual){
    
    printf("Nombre: ");
    scanf("%s", _strpClienteActual);
    printf("\nHasta pronto %s!\n", _strpClienteActual);
    fCerrarPuertas();
}

void xfImprimirClientes(){
 
    fReconocerCliente(string *_strpClienteActual);
    if(gtPrintDebounce.read() == 0.0f) {
        gbImprimirClientes = true;
    }
}

void fCerrarPuertas(){
    
    fImprimirClientes(const string * straCliente, int iNumClientes);
    Puertas = 0;
}

void fImprimirClientes(const string * straCliente, int iNumClientes){
    
    int i = 0;
    printf("Clientes dentro de la tienda: %d\n", iNumClientes);
    for(i = 0; i < iNumClientes; i++) {
        printf("%s ", *straCliente[i]);
    }
} 