#include "mbed.h"   // Librería de mbed
#include "Servo.h"  // Librería del servo; para controlar el servo
 
Serial bt(PTE0, PTE1);                    // Establece puertos que comunican con el bluetooth, como también una varialbe llamada "bt" para dichos puertos
Serial pc(USBTX,USBRX);                   // comunicacion serial con la computadora 

PwmOut servo(PTA5);                       // Establece una variable Pwm llamada "servo"

PwmOut valorBuzzer(PTB1);                 // Establece una variable Pwm llamada "valorBuzzer"

PwmOut ledDeFotoresistencia(PTC8);        // Establece una variable pwm llamada "led"
AnalogIn valorFotoresistencia(PTB3);      // Establece una variable Analogica llamada "valorFotoresistencia", esta variable la resive la freedom, 

DigitalOut ledDeSensorMovimiento(PTC9);   // Establece el led controlado por el sensor de movimiento
DigitalIn SensorMovimiento = (PTB0); // Pin de lectura del sensor de movimiento

Timer timer;                              // Declara un timer para la funcion del sensor de movimiento
 
int valorReedSwitch = 0;                  // variable para conoser el estado del reed switch
DigitalIn reedSwitch(PTA13);              // puerto del reed switch
 
void f_SensorMovimiento()                 // Funcion que controla el sensor de moviminto
{
    timer.start();                        // Inicializa el timer
    while(timer <= 3)                     // Por tres segundos...
    {
        ledDeSensorMovimiento = 1;        // se enciende el led
    }
    timer.stop();                         // Detiene el timer
    timer.reset();                        // Reinicia el tiemr
    ledDeSensorMovimiento = 0;            // Led se apaga
}
 
void f_Fotoresistencia() // funcion de la fotoresistencia
{                            
    float valor = valorFotoresistencia.read();    // lee es lavor de la fotoresistencia y la asigna a una variable flotante llamada "valor"
    
    valor = ((valorFotoresistencia - 0.039) * (-10)); // Ecuacion que recorre los valores de la freedom
    
    if(valor < 0)  // Si el valor de la fotoresistencia es menor a cero...  
    {                                    
        valor = 0; // iguala el valor a 0
    }                                               
    if(valor>1)    // Si el valor es mayor a cero...
    {                                                                           
        valor=1;   // Iguala el valor a 1
    }
    
    ledDeFotoresistencia = valor;  // Se enciende el led con una intencidad = al valor 
}      
 
 void f_Buzzer()  // Funcion del buzzer
 {                 
    bt.printf("Alarma Activada\n\r");   // Como respuesta, se imprime que la alarma ha sido activada
    valorBuzzer.period_ms(1);           // Define el periodo de PWM para el buzzer
    
    timer.start();     // Inicia el timer
    while(timer <= 5)  // Por 5 segundos...
    {
        valorBuzzer = 0.5;          // Se establece el ciclo de trabajo del buzzer, que es igual a encendido
        ledDeSensorMovimiento = 1;  // Se prenden unos leds
        wait(0.3);                  // Establece un tiempo de espera para que el buzzer deje de sonar
        valorBuzzer = 0;            // Se establece el ciclo de trabajo del buzzer, que es igual a apagado
        ledDeSensorMovimiento = 0;  // Se apagan unos leds
        wait(0.3);                  // Establece un tiempo de espera para que el buzzer vuelva a sonar
    }
    timer.stop();  // Detiene el timer
    timer.reset(); // Reinicia el timer
 }
 
int main() // Inicia el programa principal
{
 
    bt.baud(9600);       // Establece la comunicacion serial entre la KL25Z y el Bluethooth
    servo.period_ms(20); // Asigna un periodo de PWM en milisegundos, para poder utilizar el servo 
    
    while(1)  // Ciclo Infinito 
    {
        if(bt.readable())           // Establece la conexion del bluethooth
        {
            char c = bt.getc();     // Recibe un caracter via bluethoth y lo asigna a una variable char
            
            bt.printf("%c\n\r",c);  // Como respuesta, para verificar que la informacion llego a la KL25Z,
                                    // la imprime en la terminal del usuario
            if (c == 'w')
            { // Si el caracter mandado por el usuario es una "w"...
            
                servo.pulsewidth_us(1800);        // Se mueve el servo a la posicion 180°
                bt.printf("Cochera Abierta\n\r"); // Se imprime en la terminal "Cochera Abierta"
          
            }
            if (c == 's')
            { // Si el caracter mandado por el usuario es una "s"...
            
                servo.pulsewidth_us(1000);       // Se mueve el servo a la posicion 0°
                bt.printf("Cochera Cerrada\n\r"); // Se imprime en la terminal "Cochera Cerrada"
            }
            
            if( c == 'p')
            { // Si el caracter mandado por el usuario es una "p"...
                f_Buzzer(); // Se manda llamar la función f_Buzzer
            }
            
            if (c == 'm')                                     
            { // Si el caracter mandado por el usuario es una "m"...
             
                bt.printf("Iluminacion Automatica Activada\r"); // Imprime en la terminal  "Iluminacion Automatica Activada"
                
                while(c != 'v')  
                { // Si el bluethooth lee la que variable "c" es "v", se sale de este apartado
                    int valorSensorMovimiento = SensorMovimiento.read(); // Se lee el valor del sensor de movimiento 
                    if (valorSensorMovimiento == 0)                      // Si el valor es 0, significa que hay movimiento, por lo tanto... 
                    {                                       
                        f_SensorMovimiento(); // manda llamar la funcion de movimiento
                    }
                    if(bt.readable()) 
                    { // Se reestablece la conexión del bluethooth para solicitar o verificar si se cumple la opción para salir del while(c != 'v') 
                        c = bt.getc();              // Recibe un caracter via bluethoth y lo asigna a una variable 
                        ledDeSensorMovimiento = 0;  // Apaga el led si se sale de esta sección del código
                    }   
                }
                bt.printf("Iluminacion Automatica Desactivada"); // Imprime en la terminal "Iluminacion Automatica Desactivada"
            }
            
            if (c == 'a')
            { // Si el caracter mandado por el usuario es una "a"...
                
                bt.printf("Sistema de Seguridad Activado\r");   // Imprime en la terminal "Sistema de Seguridad Activado"
                
                while(c != 'v')                                
                { // Cumple con la misma función que en - if (c == 'm') -
                    int valorSensorMovimiento = SensorMovimiento.read();  // Se lee el valor del sensor de movimiento
                    if (valorSensorMovimiento == 0)                       // Si el valor es 0, significa que hay movimiento, por lo tanto... 
                    {
                        bt.printf("INTRUSO!");  // Imprime en la terminal "INTRUSO!"
                        while (c != 'e')
                        { // Si el bluethooth lee que el valor "c" es "v" se sale de este apartado      
                            f_Buzzer();
                            if(bt.readable()) 
                            { // Reestablece la conexion del bluethooth para solisitar/revisar si se cumple la opción para salir del while(c!='e')              
                                c = bt.getc();
                                ledDeSensorMovimiento = 0;        
                            }
                        }
                    }
                    if(bt.readable()) 
                    { // Reestablece la conexion del bluethooth para solisitar/revisar si se cumple la opción para salir del while(c!='v') 
                        c = bt.getc();
                        ledDeSensorMovimiento = 0;
                    }
                }
                bt.printf("Alarma Desactivada"); // Imprime en la terminal "Alarma Desactivada"
            }
            
            if(c =='f')
            { // Si el caracter mandado por el usuario es una "f"...
                bt.printf("Fotoresistencia Activada\r"); //Imprime en la terminal "Fotoresistencia Activada"
                
                while(c != 'v')
                { // Cumple con la misma función que en - if (c == 'm') -
                    f_Fotoresistencia(); // Manda llamar la funcion de la resistencia
                    
                    if(bt.readable())
                    { // Reestablece la conexion del bluethooth para solisitar/revisar si se cumple la opción para salir del while(c!='v') 
                        c = bt.getc();          
                        ledDeFotoresistencia=0;       
                    }
                }
                bt.printf("Fotoresistencia DESACTIVADA\n\r");  // Imprime en la terminal "Fotoresistencia DESACTIVADA"
            }
        }
    }
} 