#include "sgam_mdw.h"
#include "mbed.h"

#include "MPU6050.h"
#include "Gyroscope.h"

Gyroscope::Gyroscope(I2C &i2c): mpu(i2c, MPU6050_ADDRESS_AD0_LOW) { 
    mpu.initialize();

    if( mpu.testConnection() ) {
        D_LOG("Giroscope Initialized !!\r\n");
    } else {
        D_LOG("There's an error trying initialize the Gyroscope !!\r\n");
    }

    value = new GyroscopeData();
}

Gyroscope::~Gyroscope() {
    value->~GyroscopeData();
}

int Gyroscope::initialize() { D_LOG("INITIALIZE %s! \r\n", this->getName() ); return 1; }
int Gyroscope::finalize() { D_LOG("FINALIZE %s! \r\n", this->getName() ); return 1; }

void Gyroscope::getMotion(GyroscopeData* data) {
    mpu.getMotion6(
        &data->ax, &data->ay, &data->az,
        &data->gx, &data->gy, &data->gz
    );
}

GyroscopeData* Gyroscope::getValue() {
    getMotion(value);
    return value;
}

const char* Gyroscope::getName() { 
    return "Gyroscope"; 
}
