#include "mbed.h"
#include "Temperature.h"

Temperature::Temperature(PinName pin): temperature(pin){
    value = (float*) malloc(1 * sizeof(float));
    D_LOG("TEMPERATURE Initialized !!\r\n");
}

Temperature::~Temperature() { 
    if( value != NULL )
        free(value);
}

int Temperature::initialize() { D_LOG("INITIALIZE %s! \r\n", this->getName() ); return 1; }
int Temperature::finalize() { D_LOG("FINALIZE %s! \r\n", this->getName() ); return 1; }

float* Temperature::getValue() {
    *value = temperature.getTemperature();
    return value;
}

const char* Temperature::getName() { 
    return "Temperature"; 
}
