#ifndef SGAM_MDW_SENSOR_GYROSCOPE_H
#define SGAM_MDW_SENSOR_GYROSCOPE_H

#include "sgam_mdw.h"
#include "mbed.h"
#include "MPU6050.h"

class GyroscopeData {
public:
    int16_t ax, ay, az;
    int16_t gx, gy, gz;

    GyroscopeData(){}
    ~GyroscopeData(){}
};

class Gyroscope: public Sensor<GyroscopeData> {
public:
    Gyroscope(I2C &i2c);
    virtual ~Gyroscope();

    virtual int initialize();
    virtual int finalize();

    virtual GyroscopeData* getValue();
    virtual const char* getName();

private:
    MPU6050 mpu;    
    void getMotion(GyroscopeData* data);
};

#endif // SGAM_MDW_SENSOR_GYROSCOPE_H
