#ifndef SGAM_MDW_COMMUNICATION_LoRaWanComm_H
#define SGAM_MDW_COMMUNICATION_LoRaWanComm_H

#include "sgam_mdw.h"
#include "mbed.h"
#include "mbed_events.h"
#include "LoRaWANInterface.h"

// #include "helper/lora_radio_helper.h"
// #include "helper/mbedtls_lora_config.h"

class LoraData {
public:
    LoraData(lorawan_connect_t* connect_params, LoRaRadio* radio, EventQueue* ev_queue): 
    connect_params(connect_params), radio(radio), ev_queue(ev_queue) {
        confirmed_msg_retries = 3; // padrão
        enable_adaptive_datarate = true; // padrao

        callbacks = NULL;
        lora_port = 0;
        read_write_flags = 0;
    };

    void prepareCallBack(lorawan_app_callbacks_t &callbacks) {
        this->callbacks = &callbacks;
    }

    lorawan_app_callbacks_t* getCallBack() {
        return callbacks;
    }

    //////////////////////////////////////////////////////////////////////////////////
    //
    LoRaRadio* radio;
    lorawan_connect_t* connect_params;

    EventQueue* ev_queue;
    uint8_t confirmed_msg_retries;
    bool enable_adaptive_datarate;

    // Flags para leitura !!
    uint8_t lora_port;
    int read_write_flags;

private:
    lorawan_app_callbacks_t* callbacks;
};

class LoRaWanComm: public Communication<LoraData> {
public:
    LoRaWanComm(const char* parameters);
    virtual ~LoRaWanComm();
    
    virtual int initialize(LoraData* data);
    virtual int finalize();

    virtual int connect();
    virtual int disconnect();

    virtual const char* getName();
    virtual LoraData* getData();

    virtual int write(const unsigned char* buffer, int offset);
    virtual int read(unsigned char* buffer, int offset);

private:
    LoRaWANInterface* lorawan;
    LoraData* data;
};
#endif
