#include "sgam_mdw.h"
#include "mbed.h"
#include "mbed_events.h"
#include "LoRaWANInterface.h"

#include "LoRaWanComm.h"

LoRaWanComm::LoRaWanComm(const char* parameters) { } 
LoRaWanComm::~LoRaWanComm() { } 

int LoRaWanComm::initialize(LoraData* data) { 
    D_LOG("INITIALIZE %s! \r\n", this->getName() ); 

    // INICIANDO O LORAWAN !!
    this->data = data;
    if(data->getCallBack() == NULL) {
        D_LOG("You must pass a call bak method to LoraData before the initialization process! \r\n");
        return FALSE;
    }

    lorawan = new LoRaWANInterface(*data->radio);

    // 1 - Initialize LoRaWAN stack
    if (lorawan->initialize(data->ev_queue) != LORAWAN_STATUS_OK) {
        D_LOG("LoRa initialization failed! \r\n");
        return FALSE;
    }

    D_LOG("Mbed LoRaWANStack initialized \r\n");

    // prepare application callbacks
    lorawan->add_app_callbacks( data->getCallBack() );

    // confirmed messages !!
    if(data->confirmed_msg_retries > 0)
        lorawan->set_confirmed_msg_retries(data->confirmed_msg_retries);

    // Enable adaptive data rate
    if(data->enable_adaptive_datarate) {
        if (lorawan->enable_adaptive_datarate() != LORAWAN_STATUS_OK) {
            D_LOG("enable_adaptive_datarate failed! \r\n");
            return FALSE;
        }

        D_LOG("Adaptive data  rate (ADR) - Enabled \r\n");
    }

    return TRUE;
}

int LoRaWanComm::finalize() { 
    D_LOG("FINALIZE %s! \r\n", this->getName() ); 

    if(lorawan != NULL) delete lorawan;

    return 1; 
}

const char* LoRaWanComm::getName() {
    return "LoRAWAN";
}

LoraData* LoRaWanComm::getData() {
    return data;
}

int LoRaWanComm::connect() { 
    if(data->connect_params == NULL) {
        D_LOG("Please, initialize the 'connect_params' in the LoraData instance before the connection process. \r\n");
        return FALSE;
    }

    return lorawan->connect(*data->connect_params);
}

int LoRaWanComm::disconnect() {
    return -1; // lorawan->dis
}

////////////////////////////////////////////////////////////////////////////////////
int LoRaWanComm::write(const unsigned char* buffer, int offset) {
    return lorawan->send(data->lora_port, buffer, offset, data->read_write_flags);
}

int LoRaWanComm::read(unsigned char* buffer, int offset) {
    return lorawan->receive(data->lora_port, buffer, offset, data->read_write_flags);
}
