#include "sgam_mdw.h"
#include "mbed.h"

#include "ControlImpl.h"
#include "Temperature.h"
#include "Gyroscope.h"
#include "GPS.h"
#include "LoRaWanComm.h"

ControlImpl::ControlImpl() { 
    I2C i2c(I2C_SDA, I2C_SCL);
    // Incluindo os Protocolos
    // includeSensor( new Protocol() )

    // Incluindo os Sensores 
    includeSensor( (Sensor<void*>*) new Temperature(A1) );
    includeSensor( (Sensor<void*>*) new Gyroscope(i2c) );
    includeSensor( (Sensor<void*>*) new GPS() );

    // Incluindo Comunicacoes
    includeCommunication( (Communication<void*>*)new LoRaWanComm("") );
}

ControlImpl::~ControlImpl() { 
}

void ControlImpl::initialize() {
    // possiveis inicializacoes no sistema !
    D_LOG("Inicializando o Controler !\r\n");

    // INICIALIZANDO ...
    // protocolos ...
    // for (std::map<std::string, Protocol*>::iterator it=mp_protocols.begin(); it!=mp_protocols.end(); ++it)
    //     it->second->initialize();

    // // sensores ...
    // for (std::map<std::string, Sensor<void*>*>::iterator it=mp_sensors.begin(); it!=mp_sensors.end(); ++it)
    //     it->second->initialize();

    // // comunicacoes ...
    // for (std::map<std::string, Communication<void*>*>::iterator it=mp_communications.begin(); it!=mp_communications.end(); ++it)
    //     it->second->initialize();
}

void ControlImpl::finalize() {
    // // comunicacoes ...
    // for (std::map<std::string, Communication<void*>*>::iterator it=mp_communications.begin(); it!=mp_communications.end(); ++it)
    //     it->second->finalize();

    // // sensores ...
    // for (std::map<std::string, Sensor<void*>*>::iterator it=mp_sensors.begin(); it!=mp_sensors.end(); ++it)
    //     it->second->finalize();

    // // protocolos ...
    // for (std::map<std::string, Protocol*>::iterator it=mp_protocols.begin(); it!=mp_protocols.end(); ++it)
    //     it->second->finalize();
}

// metodo de instancia unica    
Control* ControlImpl::getControler() {
    return this;
}
