#include "sgam_mdw.h"
#include <map>

///////////////////////////////////////////////////////////////////////
void Control::includeSensor(Sensor<void*>* nSensor) {
    mp_sensors[(std::string)nSensor->getName()] = nSensor;
}

void Control::includeProtocol(Protocol* nProtocol) {
    mp_protocols[(std::string)nProtocol->getName()] = nProtocol;
}

void Control::includeCommunication(Communication<void*>* nCommunication) {
    mp_communications[(std::string)nCommunication->getName()] = nCommunication;
}

///////////////////////////////////////////////////////////////////////
Sensor<void*>* Control::getSensor(const char* name) {  
    return mp_sensors[(std::string)name]; 
}

Protocol* Control::getProtocol(const char* name) { 
    return mp_protocols[(std::string)name]; 
}

Communication<void*>* Control::getCommunication(const char* name) { 
    return mp_communications[(std::string)name]; 
}

///////////////////////////////////////////////////////////////////////
// list<std::string> Control::getAvailableSensors() {
//     // mp_sensors.
//     return NULL;
// }

// list<std::string> Control::getAvailableCommunications(){
//     return NULL;
// }

// list<std::string> Control::getAvailableProtocols() {
//     return NULL;
// }
