#ifndef SGAM_MDW_COMMUNICATION_H
#define SGAM_MDW_COMMUNICATION_H

template<class D>
class Communication {
public:
    Communication() { };
    virtual ~Communication(){ };
    
    virtual int initialize(D* data) = 0;
    virtual int finalize() = 0;

    virtual int connect() = 0;
    virtual int disconnect() = 0;

    virtual const char* getName() = 0;
    virtual D* getData() = 0;

    virtual int write(const unsigned char* buffer, int offset) = 0;
    virtual int read(unsigned char* buffer, int offset) = 0;

};
#endif
