#ifndef SGAM_MDW_CONTROL_H
#define SGAM_MDW_CONTROL_H

#include <string>
#include <map>

#include "utils/const_types.h"

#include "peripheral/Sensor.h"
#include "protocol/Protocol.h"
#include "communication/Communication.h"

using namespace std;

class Control {
public:
    virtual Control* getControler() = 0;
    virtual void initialize() = 0;
    virtual void finalize() = 0;

    // Incluir ...
    void includeSensor(Sensor<void*>* nSensor);
    void includeProtocol(Protocol* nProtocol);
    void includeCommunication(Communication<void*>* nCommunication);

    // metodos de GET
    Sensor<void*>* getSensor(const char* name);
    Protocol* getProtocol(const char* name);
    Communication<void*>* getCommunication(const char* name);

    // metodo para listar valores !!
    // list<const& char*> getAvailableSensors();
    // list<std::string> getAvailableCommunications();
    // list<std::string> getAvailableProtocols();

protected:
    Control(){}
    virtual ~Control(){}

    map<std::string, Sensor<void*>*> mp_sensors;
    map<std::string, Protocol*> mp_protocols;
    map<std::string, Communication<void*>*> mp_communications;
};
#endif
