#ifndef SGAM_SENSOR_H
#define SGAM_SENSOR_H

#include "mbed.h"

template <class T>
class Sensor {
public: 
    Sensor() { } ;
    ~Sensor(){ };

    virtual T getValue() = 0;
    virtual void setCallbackReadOcurred( void (*callback_sensor)(T* value), uint32_t timeout ) = 0;
    virtual void initializeTask() = 0;
    virtual void finalizeTask() = 0;

protected:
    T* value;
    void (*callback_sensor)(T* value); // callback que deve ser configurado e chamado posteriormente !

    virtual void acceptDataEvent(T* data) = 0;
};

#endif // SGAM_SENSOR_H
