#ifndef SGAM_TEMPERATURE_H
#define SGAM_TEMPERATURE_H

#include "mbed.h"
#include "Sensor.h"
#include "Grove_temperature.h"

class Temperature: public Sensor<float> {
public:
    Temperature(PinName pin);
    virtual ~Temperature();

    virtual float getValue();
    virtual void setCallbackReadOcurred( void (*callback_sensor)(float* value), uint32_t timeout );
    virtual void initializeTask();
    virtual void finalizeTask();

protected:
    static void run(void const *self_context);
    virtual void acceptDataEvent(float* data);

private:
    Grove_temperature temperature;
    Thread* t;
    uint32_t timeout;
};

#endif // SGAM_TEMPERATURE_H
