#include "mbed.h"
#include "Temperature.h"

// using namespace rtos;

Temperature::Temperature(PinName pin): temperature(pin), timeout(10*1000) { 
}

Temperature::~Temperature() {
    finalizeTask();
    temperature.~Grove_temperature();
}

float Temperature::getValue() {
    return temperature.getTemperature();
}

void Temperature::setCallbackReadOcurred( void (*callback_sensor)(float* value), uint32_t timeout = 10*1000 ) {
    Temperature::callback_sensor = callback_sensor;
    Temperature::timeout = timeout;
}

void Temperature::run(void const *self_context) {
    Temperature* self = (Temperature*)self_context;

    while(1) {
        float val = self->getValue();
        self->acceptDataEvent( &val );
        ThisThread::sleep_for(self->timeout);
    }
}

void Temperature::acceptDataEvent(float* data) {
    if(callback_sensor != NULL)
        callback_sensor(data);
}

void Temperature::initializeTask() {
    t = new Thread();
    t->start(callback(run, this));
}

void Temperature::finalizeTask() {
    if(t != NULL)
        t->terminate();
}
