#ifndef SGAM_GYROSCOPE_H
#define SGAM_GYROSCOPE_H

#include "mbed.h"
#include "Sensor.h"
#include "MPU6050.h"

class GyroscopeData {
public:
    int16_t ax, ay, az;
    int16_t gx, gy, gz;

    GyroscopeData(){}
    ~GyroscopeData(){}
};

class Gyroscope: public Sensor<GyroscopeData> {
public:
    Gyroscope(I2C &i2c);
    virtual ~Gyroscope();

    virtual GyroscopeData getValue();
    virtual void setCallbackReadOcurred( void (*callback_sensor)(GyroscopeData* value), uint32_t timeout );
    virtual void initializeTask();
    virtual void finalizeTask();

protected:
    static void run(void const *self_context);
    virtual void acceptDataEvent(GyroscopeData* data);

private:
    MPU6050 mpu;
    Thread* t;
    uint32_t timeout;
    
    void getMotion(GyroscopeData* data);
};

#endif // SGAM_GYROSCOPE_H
