#include "Logger.h"

class Giroscopio {
    public:   
        Giroscopio() {
            instance = NULL;
        }

        ~Giroscopio() {
            instance = NULL;
        }

        static void setListener(Giroscopio* newListener) {
            instance = newListener;
        }

        /// Fica ouvindo se existe movimentação, Se existir ele executa a função de CALL BACK
        static void ouvirMovimentacao() { // IRQ não pode haver LOG !!           
            if(instance != NULL) {
                instance->_movimentacoes.call( &_doMovimentsActions ); //Executar fora do IRQ
            }
        }

        void setLog(Logger * l) {
            _l = l;
        }

        void setCallBackMovimentos( void (*fnCallBack)() ){
            _fnCallBack = fnCallBack;
        }

        EventQueue* listMovimentacoes() {
            return &_movimentacoes;
        }

    private:
        Logger* _l;
        EventQueue _movimentacoes;
        void (*_fnCallBack)();

        static Giroscopio* instance ;
        static void _doMovimentsActions() {
            Giroscopio::instance->doMovimentsActions();
        } 

        void doMovimentsActions() {
            // 1 - Faz um TIME-OUT para mostrar que houve alguma movimentação !!
            _l->log("Verificando a movimentacao ...");
            _l->log("Esperando o call back ...");
            wait(0.5);

            // 2 - quando há a movimentação, então chama o call back !!
            if(_fnCallBack != NULL) {
                _fnCallBack();
                 _l->log("Call back lancado !!");
            } else {
                _l->log("Nenhum call back configurado !!");
            }
        }
}
;
