#include "mbed.h"
#include "Logger.h"

#include "Temperatura.h"
#include "Giroscopio.h"
#include "GPS.h"

#define ONE_SECOND  1000

// #define MBED_CONF_EVENTS_PRESENT
// #define MBED_CONF_RTOS_PRESENT 
// #define DEVICE_INTERRUPTIN 

DigitalOut led1 (LED1);

Logger l;
Temperatura temp;
Giroscopio giro;
GPS gps;

InterruptIn btn(BUTTON1);

EventQueue eventQueue1;
EventQueue eventQueue2;

void interrupcaoMovimentacao() {
    gps.enviaLocalizacao(10);
}

void lancaMetodo() {
    led1 = 1;
    temp.verificaTemperatura();
    wait(0.4);
    led1 = 0;
}

int main() {
    // Sistema.inicializar(/*Confs iniciais do sistema*/);
    temp.setLog(&l);
    giro.setLog(&l);
    gps.setLog(&l);

    // 1 - Fazer um time out para verificar a temperatura a cada 5 Segundos
    Thread eventThread(osPriorityNormal);
    eventThread.start(callback(&eventQueue1, &EventQueue::dispatch_forever));
 
    Ticker ledTicker;
    ledTicker.attach(eventQueue1.event(&lancaMetodo), 5.0f);

    // 2 - Verificar se houve alguma mudança no Giroscópio
    Giroscopio::setListener(&giro);
    Thread eventThread_giroscopio(osPriorityNormal);
    eventThread_giroscopio.start(callback(giro.listMovimentacoes(), &EventQueue::dispatch_forever));

    giro.setCallBackMovimentos(&interrupcaoMovimentacao);    
    btn.fall( &Giroscopio::ouvirMovimentacao ); // Usa o evento de botao para SIMULAR uma movimentação em estado de IRQ !
    
    led1 = 0;
    l.log("FINAL do main ... !");
    wait(osWaitForever);
} 
