#include "mbed.h"
#include "TSISensor.h"
// Example program for lab 5
// -------------------------
//  A value is read from the touch sensor and use
//    to control two LEDs
//  The value is also output to the serial interface
Serial pc(USBTX, USBRX); // tx, rx
DigitalOut redLED(LED_RED);
DigitalOut greenLED(LED_GREEN);
DigitalOut blueLED(LED_BLUE);
DigitalOut MIXLED(PTD5);
TSISensor tsi;
Thread redThread(osPriorityNormal,1000) ; // thread for red LED
Thread greenThread(osPriorityNormal,1000) ; // thread for green LED
Thread blueThread(osPriorityNormal,1000) ; // thread for blue LED
Thread mixcolorThread(osPriorityNormal,1000) ; // thread for mix LED
 
void red_thread() {  // methbd to run in thread
    while (true) {
        Thread::signal_wait(0x1); 
        redLED = !redLED; // turn on 
     //   blueLED = 1;
    //    greenLED = 1;    
        redThread.signal_clr(0x1) ;
          // Signal are automatically cleared by wait_signal but
          // the signal might have been set again while LED on 
    }
}
void blue_thread() {  // methbd to run in thread
    while (true) {
        Thread::signal_wait(0x1); 
  //      redLED = 1; // turn on 
        blueLED = !blueLED;
  //      greenLED = 1;    
        blueThread.signal_clr(0x1) ;
          // Signal are automatically cleared by wait_signal but
          // the signal might have been set again while LED on 
    }
}
void green_thread() {  // methbd to run in thread
    while (true) {
        Thread::signal_wait(0x1); 
   //     redLED = 1; // turn on 
    //    blueLED = 1;
        greenLED = !greenLED;    
        greenThread.signal_clr(0x1) ;
          // Signal are automatically cleared by wait_signal but
          // the signal might have been set again while LED on 
    }
}
void mixcolor_thread() {  // methbd to run in thread
    while (true) {
        Thread::signal_wait(0x1); 
      //
        MIXLED = !MIXLED;
     //
        mixcolorThread.signal_clr(0x1) ;
          // Signal are automatically cleared by wait_signal but
          // the signal might have been set again while LED on 
    }
}
int main(void) {
    uint8_t pos = 0;
    redLED = 1; // turn off 
    greenLED = 1; // turn off 
    blueLED = 1;
    MIXLED = 0;
    redThread.start(&red_thread) ; // start the red thread
    greenThread.start(&green_thread) ; // start the green thread
    blueThread.start(&blue_thread) ; // start the blue thread
    mixcolorThread.start(&mixcolor_thread) ; // start the mixcolor thread
    
    while (true) {
        uint8_t d = tsi.readDistance() ;  // Distance is between 0 and 39
                                          // When no touch --> 0
                                          // Left --> low value  Right --> high value
        pc.printf("%d", d) ;  
        pc.putc(' ') ;
        if (pos == 0)//first touch
        {
            if ((d>3) &&(d<9))pos = 1;//outerleft
            if ((d>13) &&(d<19))pos = 2;//interleft
            if ((d>23) &&(d<29))pos = 3;//interright;
            if (d>33) pos = 4;//outerright;
        }
        
        switch (pos)
        {
            case 1:
            {
                if ((d<3) ||(d>9))
                {
                    redThread.signal_set(0x1) ;
                    pos = 0;
                }
                break;
            }
            case 2:
            {
                if ((d<13) ||(d>19))
                {
                    greenThread.signal_set(0x1) ;
                    pos = 0;
                }
                break;
            }
            case 3:
            {
                if ((d<23) ||(d>29))
                {
                    blueThread.signal_set(0x1) ;
              //      pc.printf("blue");
                    pos = 0;
                }
                break;
            }
            case 4:
            {
                if (d<33)
                {
                    mixcolorThread.signal_set(0x1) ;
                    pos = 0;
                }
                break;
            }
        }
                
           
        Thread::wait(200);  // This polling rate is too slow - increase it
                            // The slower rate maks it easier to output on the terminal
    }
}