// LAB 3 SAMPLE PROGRAM 1
//   Revised for mbed 5

#include "mbed.h"


Ticker tick;                // Ticker for reading analog
AnalogIn ain(A0) ;          // Analog input
DigitalOut led1(D8);   // Red LED
DigitalOut led2(D9);
DigitalOut led3(D10);
DigitalOut led4(D11);
DigitalOut led5(D12);

DigitalIn b1(PTE1, PullUp);

Thread pollT ; // thread to poll
volatile int pressEvent = 0 ;  // Variabe set by the polling thread

enum buttonPos { up, down, bounce }; // Button positions
void polling() {
    buttonPos pos = up ;
    int bcounter = 0 ;
    while (true) {
        switch (pos) {
            case up :
                if (!b1.read()) {    // now down 
                    pressEvent = 1 ;  // transition occurred
                    pos = down ;
                }
                break ;
            case down : 
                if (b1 == 1) { // no longer down
                    bcounter = 3 ; // wait four cycles
                    pos = bounce ;
                }
                break ;
            case bounce :
                if (b1 == 0) { // down again - button has bounced
                    pos = down ;   // no event
                } else if (bcounter == 0) {
                    pos = up ;     // delay passed - reset to up
                } else {
                    bcounter-- ;   // continue waiting
                }
                break ;
        }
        Thread::wait(30);
    }
}

Serial pc(USBTX, USBRX); // tx, rx, for debugging

// Message type
typedef struct {
  uint16_t analog; /* Analog input value */
} message_t;

// Mail box
Mail<message_t, 2> mailbox;

// Function called every 10ms to read ADC
// Low pass filter  
// Every 10th value is sent to mailbox
volatile int samples = 0 ;
volatile uint16_t smoothed = 0 ; 
void readA0() {
    smoothed = (smoothed >> 1) + (ain.read_u16() >> 1) ;
    samples++ ;
    if (samples == 10) {
        // send to thread
        message_t *mess = mailbox.alloc() ; // may fail but does not block
        if (mess) {
            mess->analog = smoothed ;
            mailbox.put(mess); // fails but does not block if full
        }
        samples = 0;
    }       
}

// Write voltage digits
//   v  Voltage as scale int, e.g. 3.30 is 330
void vToString(int v, char* s) {    
    s[3] = '0' + (v % 10) ;
    v = v / 10 ;
    s[2] = '0' + (v % 10) ;
    v = v / 10 ;
    s[0] = '0' + (v % 10) ;
}

// Main program
//   Initialise variables
//   Attach ISR for ticker
//   Procss messages from mailbox    
int main() {
    
    
    pollT.start(callback(polling));
    int firstled;
   int secondled;
   int thirdled;
   int fourthled;
   int fifthled;
    volatile int max = 330;
   // led1 = 1 ; // turn off 
    int volts = 0 ;
   // const int threshold = 100 ;

   
    int counter = 0 ;
    char vstring[] = "X.XX\r\n" ;

    tick.attach_us(callback(&readA0), 10000); // ticks every 10ms
    while (true) {
        osEvent evt = mailbox.get(); // wait for mail 
        if (evt.status == osEventMail) {
            message_t* mess = (message_t*)evt.value.p ;
            volts = (mess->analog * 330) / 0xffff ;
             if (pressEvent) {
            pressEvent = 0 ; // clear the event variable
            max=volts ;
        }
            mailbox.free(mess) ;  // free the message space
            
        firstled = max*2/6;
secondled = max*3/6;
thirdled = max*4/6;
fourthled = max*5/6;
fifthled = max;
            if (volts >= firstled) led1 = 1 ; else led1 = 0 ;
            if (volts >= secondled) led2 = 1; else led2 = 0;
            if (volts >=thirdled) led3 = 1; else led3 = 0;
            if (volts >= fourthled) led4 = 1; else led4 = 0;
            if (volts >= fifthled) led5 = 1; else led5 = 0;
            
           
        
            vToString(volts, vstring) ;
            counter++ ;
            if (counter == 10) {  // limit bandwidth of serial
                pc.printf(vstring) ;
                counter = 0 ;
            }
        }

    }
}