#include "mbed.h"
#include "math.h"
#include "HIDScope.h"

// CODE THE PART WHERE WE PUT THE SIGNAL INTO RAW_SIGNAL

// Defining objects

HIDScope  scope(2);// ok

// calibration variables (GLOBAL variables), two variables per muscle
// THESE VALUES MUST COME FROM PROCESSED SIGNAL, NOT RAW SIGNAL

double MAX_VALUEA=0.78;
double MIN_VALUEA=0.09;

//double MAX_VALUEB;
//double MIN_VALUEB;

AnalogIn emg0( A0 ); // for movement up/down, named A
AnalogIn emg1( A1 );

//AnalogIn emg2( A2 ); // for movement forward/backward, named B
//AnalogIn emg3( A3 );

const double pi=3.14;

// define two functions that will be attached to the tickers
Ticker sampling; // ticker for the sampling of the signal, every 0.002s a value is sampled
Ticker processing_timer; //ticker that defines the signal processed, every second a signal is defined

// size is 3 because we apply 2nd order filters

double raw_signal_0[3];  // has the values measured via the electrodes
double raw_signal_1[3];
//double raw_signal_2[3];
//double raw_signal_3[3];

double filt0[3]; // raw_emg_1 filtered by high pass filter
double filt1[3];
//double filt2[3];
//double filt3[3];

double filt_filt0[3]; // filt1 filtered by low pass filter
double filt_filt1[3];
//double filt_filt2[3];
//double filt_filt3[3];

double notch_filt0[3]; //filt1 filtered by notch filter
double notch_filt1[3];
//double notch_filt2[3];
//double notch_filt3[3];

double emg_abs0[3]; // absolute value applied to emg
//double emg_absB[3];

double filtered0[3];

double normalized0; // not an array

bool modeA= false; // running motor at intermediate speed, derived from threshold
//bool modeB= false;

double T=0.002; // time between two samples
 
 
//void sample()
//{
 //   raw_signal_0[0]=raw_signal_0[1];
 //   raw_signal_1[0]=raw_signal_1[1];
//raw_signal_2[0]=raw_signal_2[1];
    //raw_signal_3[0]=raw_signal_3[1];
     
 //   raw_signal_0[1]=raw_signal_0[2];
 //   raw_signal_1[1]=raw_signal_1[2];
    //raw_signal_2[1]=raw_signal_2[2];
    //raw_signal_3[1]=raw_signal_3[2];
     
  //  raw_signal_0[2]=emg0.read();
  //  raw_signal_1[2]=emg1.read();
    //raw_signal_2[2]=emg2.read();
    //raw_signal_3[2]=emg3.read();

//    scope.set(0, emg0.read() );
  //  scope.send();
    
    // raw_signal=[ sign[T-2]; sign[T-1]; sign[T]]
//}

 
// BIG FUNCTION THAT INCLUDES EVERYTHING

void processing_signals()
{
    raw_signal_0[0]=raw_signal_0[1];
    raw_signal_1[0]=raw_signal_1[1];
    //raw_signal_2[0]=raw_signal_2[1];
    //raw_signal_3[0]=raw_signal_3[1];
     
    raw_signal_0[1]=raw_signal_0[2];
    raw_signal_1[1]=raw_signal_1[2];
    //raw_signal_2[1]=raw_signal_2[2];
    //raw_signal_3[1]=raw_signal_3[2];
     
    raw_signal_0[2]=emg0.read();  // most recent value
    raw_signal_1[2]=emg1.read();
    //raw_signal_2[2]=emg2.read();
    //raw_signal_3[2]=emg3.read();
     
     
    // LOWPASS FILTER
    double wclp=300*2*pi;  // cutoff omega for low pass filter
    double Q=0.7;
    
    
    // initialization of the filt arrays
    filt0[0]=filt0[1];
    //filt1[0]=filt1[1];
    //filt2[0]=filt2[1];
    //filt3[0]=filt3[1];
    
    filt0[1]=filt0[2];
    //filt1[0]=filt1[2];
    //filt2[1]=filt2[2];
    //filt3[1]=filt3[2];
    
    // initialization of the parameters
    double b0=(Q*(wclp*T)*(wclp*T))/(Q*(wclp*T)*(wclp*T)+4*Q+2*wclp*T);
    double b1=(2*Q*(wclp*T)*wclp*T)/(Q*(wclp*T)*wclp*T+4*Q+2*wclp*T);
    double b2=(Q*(wclp*T)*wclp*T)/(Q*(wclp*T)*wclp*T+4*Q+2*wclp*T);
    double a1=(-8*Q+2*Q*(wclp*T)*wclp*T)/(Q*(wclp*T)*wclp*T+4*Q+2*wclp*T);
    double a2=(4*Q-2*wclp*T+Q*(wclp*T)*wclp*T)/(Q*(wclp*T)*wclp*T+4*Q+2*wclp*T);
    
    
    filt0[2]=b0*raw_signal_0[2]+b1*raw_signal_0[1]+b2*raw_signal_0[0]-a1*filt0[1]-a2*filt0[0];
    //filt1[2]=b0*raw_signal_1[2]+b1*raw_signal_1[1]+b2*raw_signal_1[0]-a1*filt1[1]-a2*filt1[0];
    //filt2[2]=b0*raw_signal_2[2]+b1*raw_signal_2[1]+b2*raw_signal2[0]-a1*filt2[1]-a2*filt2[0];
    //filt3[2]=b0*raw_signal_3[2]+b1*raw_signal_3[1]+b2*raw_signal3[0]-a1*filt3[1]-a2*filt3[0];
    
    
    // HIGH PASS FILTER
    double wchp=10*2*pi;
    
    // initialization 
    filt_filt0[0]=filt_filt0[1];
    //filt_filt1[0]=filt_filt1[1];
    //filt_filt2[0]=filt_filt2[1];
    //filt_filt3[0]=filt_filt3[1];
    
    filt_filt0[1]=filt_filt0[2];
    //filt_filt1[1]=filt_filt1[2];
    //filt_filt2[1]=filt_filt2[2];
    //filt_filt3[1]=filt_filt3[2];
    
    // initialization of the parameters
    double d0=(4*Q)/(Q*(wchp*T)*wchp*T+2*wchp*T+4*Q);
    double d1=(-8*Q)/(Q*(wchp*T)*wchp*T+2*wchp*T+4*Q);
    double d2=(4*Q)/(Q*(wchp*T)*wchp*T+2*wchp*T+4*Q);
    double c1=(2*Q*(wchp*T)*wchp*T-8*Q)/(Q*(wchp*T)*wchp*T+2*wchp*T+4*Q);
    double c2=(4*Q-2*wchp*T+Q*(wchp*T)*wchp*T)/(Q*(wchp*T)*wchp*T+2*wchp*T+4*Q);
    
    filt_filt0[2]=d0*filt0[2]+d1*filt0[1]+d2*filt0[0]-c1*filt_filt0[1]-c2*filt_filt0[0];
    //filt_filt1[2]=d0*filt1[2]+d1*filt1[1]+d2*filt1[0]-c1*filt_filt1[1]-c2*filt_filt1[0];
    //filt_filt2[2]=d0*filt2[2]+d1*filt2[1]+d2*filt2[0]-c1*filt_filt2[1]-c2*filt_filt2[0];
    //filt_filt3[2]=d0*filt3[2]+d1*filt3[1]+d2*filt3[0]-c1*filt_filt3[1]-c2*filt_filt3[0];
     
    
    // NOTCH FILTER
    
    double l=50*2*pi;
    double b=4;
    
    double f0=(1+l*l)/(1+l*l+b);
    double f1=(-2*(1-l*l))/(1+l*l+b);
    double f2=(1+l*l)/(1+l*l+b);
    double e1=(-2*(1-l*l))/(1+l*l+b);
    double e2=(1+l*l-b)/(1+l*l+b);
    
    //initialization
    
    notch_filt0[0]=notch_filt0[1];
    //notch_filt1[0]=notch_filt1[1];
    //notch_filt2[0]=notch_filt2[1];
    //notch_filt3[0]=notch_filt3[1];
    
    notch_filt0[1]=notch_filt0[2];
    //notch_filt1[1]=notch_filt1[2];
    //notch_filt2[1]=notch_filt2[2];
    //notch_filt3[1]=notch_filt3[2];
    
    notch_filt0[2]=f0*filt_filt0[2]+f1*filt_filt0[1]+f2*filt_filt0[0]-e1*notch_filt0[1]-e2*notch_filt0[0];
    //notch_filt1[2]=f0*filt_filt1[2]+f1*filt_filt1[1]+f2*filt_filt1[0]-e1*notch_filt1[1]-e2*notch_filt1[0];
    //notch_filt2[2]=f0*filt_filt2[2]+f1*filt_filt2[1]+f2*filt_filt2[0]-e1*notch_filt2[1]-e2*notch_filt2[0];
    //notch_filt3[2]=f0*filt_filt3[2]+f1*filt_filt3[1]+f2*filt_filt3[0]-e1*notch_filt3[1]-e2*notch_filt3[0];
     
     
    
        // ABSOLUTE VALUE
    
   emg_abs0[0]=emg_abs0[1];
  emg_abs0[1]=emg_abs0[2];
    emg_abs0[2]=fabs(notch_filt0[2]);
    
    // LOW PASS FILTER
    
    double wcvlp=5*2*pi;  // cutoff omega for low pass filter
    
    double filtered0[3];
    
    // initialization of the filt arrays
    filtered0[0]=filtered0[1];  
    filtered0[1]=filtered0[2];
    
    
    // initialization of the parameters
    double k0=(Q*(wcvlp*T)*wcvlp*T)/(Q*(wcvlp*T)*wcvlp*T+4*Q+2*wcvlp*T);
    double k1=(2*Q*(wcvlp*T)*wcvlp*T)/(Q*(wcvlp*T)*wcvlp*T+4*Q+2*wcvlp*T);
    double k2=(Q*(wcvlp*T)*wcvlp*T)/(Q*(wcvlp*T)*wcvlp*T+4*Q+2*wcvlp*T);
    double g1=(-8*Q+2*Q*(wcvlp*T)*wcvlp*T)/(Q*(wcvlp*T)*wcvlp*T+4*Q+2*wcvlp*T);
    double g2=(4*Q-2*wcvlp*T*Q*(wcvlp*T)*wcvlp*T)/(Q*(wcvlp*T)*wcvlp*T+4*Q+2*wcvlp*T);
    
    
    filtered0[2]=k0*emg_abs0[2]+k1*emg_abs0[1]+k2*emg_abs0[0]-g1*filtered0[1]-g2*filtered0[0];
    //filt1[2]=k0*raw_signal_1[2]+k1*raw_signal_1[1]+k2*raw_signal_1[0]-g1*filt1[1]-g2*filt1[0];
    //filt2[2]=k0*raw_signal_2[2]+k1*raw_signal_2[1]+k2*raw_signal2[0]-g1*filt2[1]-g2*filt2[0];
    //filt3[2]=k0*raw_signal_3[2]+k1*raw_signal_3[1]+k2*raw_signal3[0]-g1*filt3[1]-g2*filt3[0];
    
    
    // NORMALIZATION
    
    normalized0=(fabs(filtered0[2])-MIN_VALUEA)/(MAX_VALUEA-MIN_VALUEA);  //final value is mapped to [0,1]  
    
    // determine a threshold experimentally
    
    scope.set(0, emg0.read() );  
    scope.set(1, normalized0 );
    scope.send();
    
}
    
    
int main()
{
  //  sampling.attach(&sample, 0.002);
    processing_timer.attach(&processing_signals, 0.002);
    
    while (1){}
    // return 0;
}