#include "mbed.h"
#include "MODSERIAL.h"
#include "FastPWM.h"
#include "QEI.h"
#include "HIDScope.h"
#include "math.h"


/* We want to feed the motor with a sinus VELOCITY input and get the angular POSITION thanks to the encoder*/

Ticker signal; // helps us to define the signal
DigitalOut motor1DirectionPin(D7); //Boolean, determines direction
FastPWM motor1MagnitudePin(D6); //PWM ranges from 0 to 1, determines velocity of the motor

double MotorValue; 
Serial pc(USBTX,USBRX);
double MeasuredPosition=0; //Measured position in rad
QEI Encoder(D1,D0,NC,32);
int ReferencePosition=3150; // reference position
double ReferenceVelocity;

int f; // frequency of the sinus
double pi=3.14;

double abs_time=0; //absolute time : where we are right now in the time signal
//CHECK IF RIGHT TO PASS ABS_TIME BY REFERENCE (we want it changed)

double GetReferenceVelocity(double &t)  // computes the reference velocity we will feed the motor with
{
    double refval;  // input reference velocity
    refval=sin(2*pi*t*f);
    t=t+0.01; // sinus valuescomputed every 0.01 seconds  
    return refval;
}

    
void setMotor1(double b){  // b is refval
    if (b>=0)
    {    
        motor1DirectionPin=1;
    }
    else 
    {
        motor1DirectionPin=0;
    }
    motor1MagnitudePin=fabs(b);
}


void control()
{
    ReferenceVelocity=GetReferenceVelocity(abs_time);
    MeasuredPosition=Encoder.getPulses();
    printf("Reference Velocity: %d\r\n", ReferenceVelocity);
    printf("MeasuredPosition: %d\r\n",MeasuredPosition);
    setMotor1(ReferenceVelocity);
}

int main(void)
{
    pc.baud(112500);
    signal.attach(control, 0.01);
    while(abs_time<10)
    {
    }
        
}
        