#include "bma180.h"
 
#define ID         0x00
#define VERSION    0x01
#define XaccLSB    0x02
#define XaccMSB    0x03
#define YaccLSB    0x04
#define YaccMSB    0x05
#define ZaccLSB    0x06
#define ZaccMSB    0x07
#define CTRL_REG0  0x0D
#define CTRL_REG1  0x0E
#define CTRL_REG2  0x0F
#define RESET      0x10
#define BW         0x20
#define CTRL_REG3  0x21
#define CTRL_REG4  0x22
#define DIS_I2C    0x27
#define MODE       0x30
#define RANGE      0x35
 
#include "mbed.h"
 
BMA180::BMA180(SPI& spi, PinName cs): _spi(spi), _cs(cs) {
    _spi.format(8,3);
    _spi.frequency(10000000);
        
}
 
void BMA180::readX() {
    _cs = 0;  
    _spi.write(XaccLSB | 0x80);
    data[0] = _spi.write(XaccMSB | 0x80);
    data[1] = _spi.write(XaccMSB | 0x80);
    _cs = 1;
    xi = (data[1]<<6) | (data[0]>>2);
}
void BMA180::readY() {
    _cs = 0; 
    _spi.write(YaccLSB | 0x80);
    data[2] = _spi.write(YaccMSB | 0x80);
    data[3] = _spi.write(YaccMSB | 0x80);
    _cs = 1;
    yi = (data[3]<<6) | (data[2]>>2);
}
void BMA180::readZ() {
    _cs = 0; 
    _spi.write(ZaccLSB | 0x80);
    data[4] = _spi.write(ZaccMSB | 0x80);
    data[5] = _spi.write(ZaccMSB | 0x80);
    _cs = 1;
    zi = (data[5]<<6) | (data[4]>>2);
}
void BMA180::readRaw() {
    _cs = 0; 
    _spi.write(XaccLSB | 0x80);
    data[0] = _spi.write(0x80);
    data[1] = _spi.write(0x80);
    data[2] = _spi.write(0x80);
    data[3] = _spi.write(0x80);
    data[4] = _spi.write(0x80);
    data[5] = _spi.write(0x80);
    _cs = 1;
    x = (data[1]<<6) | (data[0]>>2);
    if(x>=0x2000)
        {
            x -= 0x4000;
            xi = x;
        }
    else
        {    
            xi = x;
        }
    x/=0x2000;
    y = (data[3]<<6) | (data[2]>>2);
    if(y>=0x2000)
        {
            y -= 0x4000;
            yi =y;
        }
    else
        {
            yi = y;
        }
    y/=0x2000;
    z = (data[5]<<6) | (data[4]>>2);
    if(z>=0x2000)
        {
            z -= 0x4000;
            zi =z;
        }
    else
        {
            zi=z;
        }
    z/=0x2000;
}
char BMA180::write(char address,char data) {
     address &= 0x7F;
     _cs = 0;
     _spi.write(address);
     _spi.write(data);
     _cs = 1;
     return 1;
}
char BMA180::read(char address) {
    char data;
    address |= 0x80;
    _cs = 0;
    _spi.write(address);
    data = _spi.write(0xFF);
    _cs = 1;
    return data;
}
void BMA180::softReset() {
    _cs = 0; wait_us(2);
    _spi.write(RESET & 0x7F); wait_us(2);
    _spi.write(0xB6); 
    _cs = 1; wait_us(2);
}   
void BMA180::range(int r) {
    char byte;
    
    byte = read(CTRL_REG0);                         //unlock image writing
    _cs = 0; wait_us(2);
    _spi.write(CTRL_REG0 & 0x7F);
    _spi.write(byte | 0x10);
    _cs = 1; wait_us(2);
    
    byte = read(RANGE);                             //set the range of acceleromter
    byte &= 0xF1; 
    if(r>6)
        byte |= 0x02;
    else 
        byte |= (r<<1);
    _cs = 0; wait_us(2);
    _spi.write(RANGE & 0x7F);
    _spi.write(byte);
    _cs = 1; wait_us(2);
    
    byte = read(CTRL_REG0);                         //lock image writing
    _cs = 0; wait_us(2);
    _spi.write(CTRL_REG0 & 0x7F);
    _spi.write(byte & 0xEF);
    _cs = 1; wait_us(2);
}
void BMA180::bw(int r){
    char byte;
    
    byte = read(CTRL_REG0);                         //unlock image writing
    _cs = 0; wait_us(2);
    _spi.write(CTRL_REG0 & 0x7F);
    _spi.write(byte | 0x10);
    _cs = 1; wait_us(2);
    
    byte = read(BW);                                //bandwidth of acc
    byte &= 0x0F;
    if (r>9)
        byte |= 0x70;
    else
        byte |= (r<<4);    
    _cs = 0; wait_us(2);
    _spi.write(BW & 0x7F);
    _spi.write(byte);
    _cs = 1; wait_us(2);
    
    byte = read(CTRL_REG0);                         //lock image writing
    _cs = 0; wait_us(2);
    _spi.write(CTRL_REG0 & 0x7F); 
    _spi.write(byte & 0xEF); 
    _cs = 1; wait_us(2);
}
    
void BMA180::init() {
    char byte;
    wait_us(10000);
    byte = read(CTRL_REG0);                         //unlock image writing
    _cs = 0; wait_us(2);
    _spi.write(CTRL_REG0 & 0x7F); 
    _spi.write(byte | 0x10); 
    _cs = 1; wait_us(2);
     
    byte = read(DIS_I2C);                           //disable I2C
    _cs = 0; wait_us(2);
    _spi.write(DIS_I2C & 0x7F);
    _spi.write(byte | 0x01);
    _cs = 1; wait_us(2);
    
    byte = read(MODE);                              //mode of acc
    _cs = 0; wait_us(2);
    _spi.write(MODE & 0x7F);
    _spi.write(byte & 0xFC);
    _cs = 1; wait_us(2);
        
    byte = read(CTRL_REG0);                         //lock image writing
    _cs = 0; wait_us(2);
    _spi.write(CTRL_REG0 & 0x7F); 
    _spi.write(byte & 0xEF);
    _cs = 1; wait_us(2);
}