// -- Example program for the SSH1106 library - written for LPC1768
// -- Tested with a 1.3" 128x64 OLED LCD

#include "mbed.h"
#include "SSH1106.h"

SPI lcd(p11, NC, p13);      // mosi, miso (nc), sclk
DigitalOut cs(p15);         // chip select  (active low)
DigitalOut cd(p14);         // command/data (0=command, 1=data)
DigitalOut rst(p16);        // Reset (active low)

SSH1106 ssh1106(lcd, cs, cd, rst); 

int main()
{
    ssh1106.init();
    wait(1);
    ssh1106.clear();
    wait(1);
    char str[40];
    int n = 6;
    n = sprintf(str, "01234ABCdefghijk");
    while(1) {
        
        ssh1106.drawBitmap(test);
        wait(1);
        ssh1106.drawBitmap(einstein);
        wait(1);
        ssh1106.drawBitmap(biohazard);
        wait(1);
        ssh1106.drawBitmap(highvoltage);
        wait(1);
        ssh1106.drawBitmap(copter);
        wait(1);
        ssh1106.clear();
        ssh1106.clearBuffer();
        ssh1106.drawbufferLineHor(10, 7, 4, 108);
        ssh1106.drawbufferLineVert(62, 7, 55, 4);
        ssh1106.update();
        wait(1);
        //ssh1106.drawLineVert(62, 10, 40, 4);
        //wait(5);        
        ssh1106.clear();
        ssh1106.writeText(0,0, font_6x6, str, n);
        ssh1106.writeText(0,1, font_7x7, str, n);
        ssh1106.writeText(0,2, bold_font, str, n);
        ssh1106.writeText(0,3, font_5x8, str, n);
        ssh1106.writeText2d(0,4, font2d_hunter, str, n);
        ssh1106.writeText(0,5, font_8x8_1, str, n);
        ssh1106.writeText2d(0,6, font2d_formplex12, str, n);
        ssh1106.writeText(0,7, font_4x5, str, n);
        wait(5);
    }
}
