#ifndef FONT8x8_1_H
#define FONT8x8_1_H

/* Created with PixelFontEdit-2.7
 * The array starts with a 8 byte header:
 *  1st Byte: 'F' first 2 bytes are always FV
 *  2nd Byte: 'V' for FONT VERTICAL
 *  3rd Byte: First code to define
 *  4th Byte: Last  code to define
 *  5th Byte: Width of character in dots
 *  6th Byte: Height of character in dots
 *  7th Byte: Height of character in bytes
 *  8th Byte: Bytes needed for each character (1..255)
              or 0 for big fonts calculate WidthInDots * HeightInBytes
 * After that font data will follow
 */

const char font_8x8_1[] =
{
    70, 86, 0, 255,  8,  8,  1,  8,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, // Char 000 (.)
    0x7E, 0x81, 0x95, 0xB1, 0xB1, 0x95, 0x81, 0x7E, // Char 001 (.)
    0x7E, 0xFF, 0xEB, 0xCF, 0xCF, 0xEB, 0xFF, 0x7E, // Char 002 (.)
    0x0E, 0x1F, 0x3F, 0x7E, 0x3F, 0x1F, 0x0E, 0x00, // Char 003 (.)
    0x08, 0x1C, 0x3E, 0x7F, 0x3E, 0x1C, 0x08, 0x00, // Char 004 (.)
    0x18, 0xBA, 0xFF, 0xFF, 0xFF, 0xBA, 0x18, 0x00, // Char 005 (.)
    0x10, 0xB8, 0xFC, 0xFF, 0xFC, 0xB8, 0x10, 0x00, // Char 006 (.)
    0x00, 0x00, 0x18, 0x3C, 0x3C, 0x18, 0x00, 0x00, // Char 007 (.)
    0xFF, 0xFF, 0xE7, 0xC3, 0xC3, 0xE7, 0xFF, 0xFF, // Char 008 (.)
    0x00, 0x3C, 0x66, 0x42, 0x42, 0x66, 0x3C, 0x00, // Char 009 (.)
    0xFF, 0xC3, 0x99, 0xBD, 0xBD, 0x99, 0xC3, 0xFF, // Char 010 (.)
    0x70, 0xF8, 0x88, 0x88, 0xFD, 0x7F, 0x07, 0x0F, // Char 011 (.)
    0x00, 0x4E, 0x5F, 0xF1, 0xF1, 0x5F, 0x4E, 0x00, // Char 012 (.)
    0xC0, 0xE0, 0xFF, 0x7F, 0x05, 0x05, 0x07, 0x07, // Char 013 (.)
    0xC0, 0xFF, 0x7F, 0x05, 0x05, 0x65, 0x7F, 0x3F, // Char 014 (.)
    0x99, 0x5A, 0x3C, 0xE7, 0xE7, 0x3C, 0x5A, 0x99, // Char 015 (.)
    0x7F, 0x3E, 0x3E, 0x1C, 0x1C, 0x08, 0x08, 0x00, // Char 016 (.)
    0x08, 0x08, 0x1C, 0x1C, 0x3E, 0x3E, 0x7F, 0x00, // Char 017 (.)
    0x00, 0x24, 0x66, 0xFF, 0xFF, 0x66, 0x24, 0x00, // Char 018 (.)
    0x00, 0x5F, 0x5F, 0x00, 0x00, 0x5F, 0x5F, 0x00, // Char 019 (.)
    0x06, 0x0F, 0x09, 0x7F, 0x7F, 0x01, 0x7F, 0x7F, // Char 020 (.)
    0x40, 0xDA, 0xBF, 0xA5, 0xFD, 0x5B, 0x02, 0x00, // Char 021 (.)
    0x00, 0x70, 0x70, 0x70, 0x70, 0x70, 0x70, 0x00, // Char 022 (.)
    0x80, 0x94, 0xB6, 0xFF, 0xFF, 0xB6, 0x94, 0x80, // Char 023 (.)
    0x00, 0x04, 0x06, 0x7F, 0x7F, 0x06, 0x04, 0x00, // Char 024 (.)
    0x00, 0x10, 0x30, 0x7F, 0x7F, 0x30, 0x10, 0x00, // Char 025 (.)
    0x08, 0x08, 0x08, 0x2A, 0x3E, 0x1C, 0x08, 0x00, // Char 026 (.)
    0x08, 0x1C, 0x3E, 0x2A, 0x08, 0x08, 0x08, 0x00, // Char 027 (.)
    0x3C, 0x3C, 0x20, 0x20, 0x20, 0x20, 0x20, 0x00, // Char 028 (.)
    0x08, 0x1C, 0x3E, 0x08, 0x08, 0x3E, 0x1C, 0x08, // Char 029 (.)
    0x30, 0x38, 0x3C, 0x3E, 0x3E, 0x3C, 0x38, 0x30, // Char 030 (.)
    0x06, 0x0E, 0x1E, 0x3E, 0x3E, 0x1E, 0x0E, 0x06, // Char 031 (.)
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, // Char 032 ( )
    0x00, 0x06, 0x5F, 0x5F, 0x06, 0x00, 0x00, 0x00, // Char 033 (!)
    0x00, 0x07, 0x07, 0x00, 0x07, 0x07, 0x00, 0x00, // Char 034 (")
    0x14, 0x7F, 0x7F, 0x14, 0x7F, 0x7F, 0x14, 0x00, // Char 035 (#)
    0x24, 0x2E, 0x6B, 0x6B, 0x3A, 0x12, 0x00, 0x00, // Char 036 ($)
    0x46, 0x66, 0x30, 0x18, 0x0C, 0x66, 0x62, 0x00, // Char 037 (%)
    0x30, 0x7A, 0x4F, 0x5D, 0x37, 0x7A, 0x48, 0x00, // Char 038 (&)
    0x04, 0x07, 0x03, 0x00, 0x00, 0x00, 0x00, 0x00, // Char 039 (')
    0x00, 0x1C, 0x3E, 0x63, 0x41, 0x00, 0x00, 0x00, // Char 040 (()
    0x00, 0x41, 0x63, 0x3E, 0x1C, 0x00, 0x00, 0x00, // Char 041 ())
    0x08, 0x2A, 0x3E, 0x1C, 0x1C, 0x3E, 0x2A, 0x08, // Char 042 (*)
    0x08, 0x08, 0x3E, 0x3E, 0x08, 0x08, 0x00, 0x00, // Char 043 (+)
    0x00, 0x80, 0xE0, 0x60, 0x00, 0x00, 0x00, 0x00, // Char 044 (,)
    0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x00, 0x00, // Char 045 (-)
    0x00, 0x00, 0x60, 0x60, 0x00, 0x00, 0x00, 0x00, // Char 046 (.)
    0x60, 0x30, 0x18, 0x0C, 0x06, 0x03, 0x01, 0x00, // Char 047 (/)
    0x3E, 0x7F, 0x71, 0x59, 0x4D, 0x7F, 0x3E, 0x00, // Char 048 (0)
    0x00, 0x02, 0x7F, 0x7F, 0x00, 0x00, 0x00, 0x00, // Char 049 (1)
    0x62, 0x73, 0x59, 0x49, 0x4F, 0x46, 0x00, 0x00, // Char 050 (2)
    0x22, 0x63, 0x49, 0x49, 0x7F, 0x36, 0x00, 0x00, // Char 051 (3)
    0x18, 0x1C, 0x16, 0x13, 0x7F, 0x7F, 0x10, 0x00, // Char 052 (4)
    0x27, 0x67, 0x45, 0x45, 0x7D, 0x39, 0x00, 0x00, // Char 053 (5)
    0x3C, 0x7E, 0x4B, 0x49, 0x79, 0x30, 0x00, 0x00, // Char 054 (6)
    0x01, 0x01, 0x71, 0x79, 0x0F, 0x07, 0x00, 0x00, // Char 055 (7)
    0x36, 0x7F, 0x49, 0x49, 0x7F, 0x36, 0x00, 0x00, // Char 056 (8)
    0x06, 0x4F, 0x49, 0x69, 0x3F, 0x1E, 0x00, 0x00, // Char 057 (9)
    0x00, 0x00, 0x66, 0x66, 0x00, 0x00, 0x00, 0x00, // Char 058 (:)
    0x00, 0x80, 0xE6, 0x66, 0x00, 0x00, 0x00, 0x00, // Char 059 (;)
    0x08, 0x1C, 0x36, 0x63, 0x41, 0x00, 0x00, 0x00, // Char 060 (<)
    0x24, 0x24, 0x24, 0x24, 0x24, 0x24, 0x00, 0x00, // Char 061 (=)
    0x00, 0x41, 0x63, 0x36, 0x1C, 0x08, 0x00, 0x00, // Char 062 (>)
    0x02, 0x03, 0x51, 0x59, 0x0F, 0x06, 0x00, 0x00, // Char 063 (?)
    0x3E, 0x7F, 0x41, 0x5D, 0x5D, 0x1F, 0x1E, 0x00, // Char 064 (@)
    0x00, 0x7C, 0x7E, 0x13, 0x13, 0x7E, 0x7C, 0x00, // Char 065 (A)
    0x00, 0x7F, 0x7F, 0x49, 0x49, 0x7F, 0x36, 0x00, // Char 066 (B)
    0x1C, 0x3E, 0x63, 0x41, 0x41, 0x63, 0x22, 0x00, // Char 067 (C)
    0x00, 0x7F, 0x7F, 0x41, 0x63, 0x3E, 0x1C, 0x00, // Char 068 (D)
    0x00, 0x7F, 0x7F, 0x49, 0x49, 0x41, 0x41, 0x00, // Char 069 (E)
    0x00, 0x7F, 0x7F, 0x09, 0x09, 0x01, 0x01, 0x00, // Char 070 (F)
    0x1C, 0x3E, 0x63, 0x41, 0x51, 0x73, 0x72, 0x00, // Char 071 (G)
    0x00, 0x7F, 0x7F, 0x08, 0x08, 0x7F, 0x7F, 0x00, // Char 072 (H)
    0x00, 0x00, 0x00, 0x7F, 0x7F, 0x00, 0x00, 0x00, // Char 073 (I)
    0x00, 0x30, 0x70, 0x40, 0x40, 0x7F, 0x3F, 0x00, // Char 074 (J)
    0x00, 0x7F, 0x7F, 0x08, 0x1C, 0x77, 0x63, 0x00, // Char 075 (K)
    0x00, 0x7F, 0x7F, 0x40, 0x40, 0x40, 0x40, 0x00, // Char 076 (L)
    0x7F, 0x7F, 0x0E, 0x1C, 0x0E, 0x7F, 0x7F, 0x00, // Char 077 (M)
    0x7F, 0x7F, 0x06, 0x0C, 0x18, 0x7F, 0x7F, 0x00, // Char 078 (N)
    0x00, 0x3E, 0x7F, 0x41, 0x41, 0x7F, 0x3E, 0x00, // Char 079 (O)
    0x00, 0x7F, 0x7F, 0x09, 0x09, 0x0F, 0x06, 0x00, // Char 080 (P)
    0x00, 0x1E, 0x3F, 0x21, 0x71, 0x7F, 0x5E, 0x00, // Char 081 (Q)
    0x00, 0x7F, 0x7F, 0x09, 0x19, 0x7F, 0x66, 0x00, // Char 082 (R)
    0x00, 0x26, 0x6F, 0x4D, 0x59, 0x73, 0x32, 0x00, // Char 083 (S)
    0x00, 0x01, 0x01, 0x7F, 0x7F, 0x01, 0x01, 0x00, // Char 084 (T)
    0x00, 0x3F, 0x7F, 0x40, 0x40, 0x7F, 0x7F, 0x00, // Char 085 (U)
    0x00, 0x1F, 0x3F, 0x60, 0x60, 0x3F, 0x1F, 0x00, // Char 086 (V)
    0x7F, 0x7F, 0x30, 0x18, 0x30, 0x7F, 0x7F, 0x00, // Char 087 (W)
    0x00, 0x63, 0x77, 0x1C, 0x1C, 0x77, 0x63, 0x00, // Char 088 (X)
    0x00, 0x07, 0x0F, 0x78, 0x78, 0x0F, 0x07, 0x00, // Char 089 (Y)
    0x41, 0x61, 0x71, 0x59, 0x4D, 0x47, 0x43, 0x00, // Char 090 (Z)
    0x00, 0x7F, 0x7F, 0x41, 0x41, 0x00, 0x00, 0x00, // Char 091 ([)
    0x01, 0x03, 0x06, 0x0C, 0x18, 0x30, 0x60, 0x00, // Char 092 (\)
    0x00, 0x41, 0x41, 0x7F, 0x7F, 0x00, 0x00, 0x00, // Char 093 (])
    0x08, 0x0C, 0x06, 0x03, 0x06, 0x0C, 0x08, 0x00, // Char 094 (^)
    0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, // Char 095 (_)
    0x00, 0x00, 0x03, 0x07, 0x04, 0x00, 0x00, 0x00, // Char 096 (`)
    0x00, 0x20, 0x74, 0x54, 0x54, 0x3C, 0x78, 0x00, // Char 097 (a)
    0x00, 0x7F, 0x3F, 0x48, 0x48, 0x78, 0x30, 0x00, // Char 098 (b)
    0x00, 0x38, 0x7C, 0x44, 0x44, 0x6C, 0x28, 0x00, // Char 099 (c)
    0x00, 0x30, 0x78, 0x48, 0x48, 0x3F, 0x7F, 0x00, // Char 100 (d)
    0x00, 0x38, 0x7C, 0x54, 0x54, 0x5C, 0x18, 0x00, // Char 101 (e)
    0x00, 0x08, 0x7E, 0x7F, 0x09, 0x03, 0x02, 0x00, // Char 102 (f)
    0x00, 0x18, 0xBC, 0xA4, 0xA4, 0xF8, 0x7C, 0x00, // Char 103 (g)
    0x00, 0x7F, 0x7F, 0x08, 0x04, 0x7C, 0x78, 0x00, // Char 104 (h)
    0x00, 0x00, 0x00, 0x7D, 0x7D, 0x00, 0x00, 0x00, // Char 105 (i)
    0x60, 0xE0, 0x80, 0x80, 0xFD, 0x7D, 0x00, 0x00, // Char 106 (j)
    0x00, 0x7F, 0x7F, 0x10, 0x38, 0x6C, 0x44, 0x00, // Char 107 (k)
    0x00, 0x00, 0x00, 0x7F, 0x7F, 0x00, 0x00, 0x00, // Char 108 (l)
    0x7C, 0x7C, 0x18, 0x30, 0x18, 0x7C, 0x7C, 0x00, // Char 109 (m)
    0x00, 0x7C, 0x7C, 0x04, 0x04, 0x7C, 0x78, 0x00, // Char 110 (n)
    0x00, 0x38, 0x7C, 0x44, 0x44, 0x7C, 0x38, 0x00, // Char 111 (o)
    0x00, 0xFC, 0xF8, 0x24, 0x24, 0x3C, 0x18, 0x00, // Char 112 (p)
    0x00, 0x18, 0x3C, 0x24, 0x24, 0xF8, 0xFC, 0x00, // Char 113 (q)
    0x00, 0x7C, 0x78, 0x0C, 0x04, 0x0C, 0x08, 0x00, // Char 114 (r)
    0x00, 0x48, 0x5C, 0x54, 0x54, 0x74, 0x24, 0x00, // Char 115 (s)
    0x00, 0x04, 0x3F, 0x7F, 0x44, 0x24, 0x00, 0x00, // Char 116 (t)
    0x00, 0x3C, 0x7C, 0x40, 0x40, 0x3C, 0x7C, 0x00, // Char 117 (u)
    0x00, 0x1C, 0x3C, 0x60, 0x60, 0x3C, 0x1C, 0x00, // Char 118 (v)
    0x3C, 0x7C, 0x70, 0x38, 0x70, 0x7C, 0x3C, 0x00, // Char 119 (w)
    0x44, 0x6C, 0x38, 0x10, 0x38, 0x6C, 0x44, 0x00, // Char 120 (x)
    0x00, 0x1C, 0xBC, 0xA0, 0xA0, 0xFC, 0x7C, 0x00, // Char 121 (y)
    0x00, 0x44, 0x64, 0x74, 0x5C, 0x4C, 0x44, 0x00, // Char 122 (z)
    0x08, 0x08, 0x3E, 0x77, 0x41, 0x41, 0x00, 0x00, // Char 123 ({)
    0x00, 0x00, 0x00, 0x77, 0x77, 0x00, 0x00, 0x00, // Char 124 (|)
    0x41, 0x41, 0x77, 0x3E, 0x08, 0x08, 0x00, 0x00, // Char 125 (})
    0x02, 0x03, 0x01, 0x03, 0x02, 0x03, 0x01, 0x00, // Char 126 (~)
    0x70, 0x78, 0x4C, 0x46, 0x4C, 0x78, 0x70, 0x00, // Char 127 (.)
    0x00, 0x78, 0x7C, 0x16, 0x13, 0x7F, 0x7F, 0x00, // Char 128 (.)
    0x00, 0x7F, 0x7F, 0x49, 0x49, 0x79, 0x30, 0x00, // Char 129 (.)
    0x00, 0x7F, 0x7F, 0x49, 0x49, 0x7F, 0x36, 0x00, // Char 130 (.)
    0x00, 0x7F, 0x7F, 0x01, 0x01, 0x01, 0x01, 0x00, // Char 131 (.)
    0xC0, 0xFC, 0x7E, 0x43, 0x7F, 0xFF, 0xC0, 0x00, // Char 132 (.)
    0x00, 0x7F, 0x7F, 0x49, 0x49, 0x49, 0x41, 0x00, // Char 133 (.)
    0x63, 0x77, 0x1C, 0x7F, 0x7F, 0x1C, 0x77, 0x63, // Char 134 (.)
    0x00, 0x22, 0x63, 0x49, 0x49, 0x7F, 0x36, 0x00, // Char 135 (.)
    0x00, 0x7F, 0x7F, 0x18, 0x0C, 0x7F, 0x7F, 0x00, // Char 136 (.)
    0x00, 0x7E, 0x7F, 0x19, 0x0D, 0x7F, 0x7E, 0x00, // Char 137 (.)
    0x00, 0x7F, 0x7F, 0x1C, 0x36, 0x63, 0x41, 0x00, // Char 138 (.)
    0x00, 0x78, 0x7C, 0x06, 0x03, 0x7F, 0x7F, 0x00, // Char 139 (.)
    0x7F, 0x7F, 0x0E, 0x3C, 0x0E, 0x7F, 0x7F, 0x00, // Char 140 (.)
    0x00, 0x7F, 0x7F, 0x08, 0x08, 0x7F, 0x7F, 0x00, // Char 141 (.)
    0x00, 0x3E, 0x7F, 0x41, 0x41, 0x7F, 0x3E, 0x00, // Char 142 (.)
    0x00, 0x7F, 0x7F, 0x01, 0x01, 0x7F, 0x7F, 0x00, // Char 143 (.)
    0x00, 0x7F, 0x7F, 0x11, 0x11, 0x1F, 0x0E, 0x00, // Char 144 (.)
    0x00, 0x3E, 0x7F, 0x41, 0x41, 0x63, 0x22, 0x00, // Char 145 (.)
    0x00, 0x01, 0x01, 0x7F, 0x7F, 0x01, 0x01, 0x00, // Char 146 (.)
    0x00, 0x27, 0x6F, 0x48, 0x48, 0x7F, 0x3F, 0x00, // Char 147 (.)
    0x0E, 0x1F, 0x11, 0x7F, 0x7F, 0x11, 0x1F, 0x0E, // Char 148 (.)
    0x00, 0x63, 0x77, 0x1C, 0x1C, 0x77, 0x63, 0x00, // Char 149 (.)
    0x00, 0x7F, 0x7F, 0x40, 0x40, 0x7F, 0xFF, 0xC0, // Char 150 (.)
    0x00, 0x07, 0x0F, 0x08, 0x08, 0x7F, 0x7F, 0x00, // Char 151 (.)
    0x7F, 0x7F, 0x40, 0x7F, 0x7F, 0x40, 0x7F, 0x7F, // Char 152 (.)
    0x7F, 0x7F, 0x40, 0x7F, 0x7F, 0x40, 0xFF, 0xFF, // Char 153 (.)
    0x01, 0x7F, 0x7F, 0x48, 0x48, 0x78, 0x30, 0x00, // Char 154 (.)
    0x7F, 0x7F, 0x48, 0x78, 0x30, 0x7F, 0x7F, 0x00, // Char 155 (.)
    0x00, 0x7F, 0x7F, 0x48, 0x48, 0x78, 0x30, 0x00, // Char 156 (.)
    0x22, 0x41, 0x49, 0x49, 0x6B, 0x3E, 0x1C, 0x00, // Char 157 (.)
    0x7F, 0x7F, 0x08, 0x3E, 0x7F, 0x41, 0x7F, 0x3E, // Char 158 (.)
    0x00, 0x4E, 0x7F, 0x31, 0x11, 0x7F, 0x7F, 0x00, // Char 159 (.)
    0x00, 0x20, 0x74, 0x54, 0x54, 0x3C, 0x78, 0x00, // Char 160 (.)
    0x00, 0x34, 0x7E, 0x4A, 0x4A, 0x7A, 0x30, 0x00, // Char 161 (.)
    0x00, 0x7C, 0x7C, 0x54, 0x54, 0x7C, 0x28, 0x00, // Char 162 (.)
    0x00, 0x7C, 0x7C, 0x04, 0x04, 0x04, 0x04, 0x00, // Char 163 (.)
    0xC0, 0x70, 0x78, 0x4C, 0x7C, 0x7C, 0xC0, 0x00, // Char 164 (.)
    0x00, 0x38, 0x7C, 0x54, 0x54, 0x5C, 0x18, 0x00, // Char 165 (.)
    0x44, 0x6C, 0x38, 0x7C, 0x7C, 0x38, 0x6C, 0x44, // Char 166 (.)
    0x00, 0x28, 0x6C, 0x44, 0x54, 0x7C, 0x28, 0x00, // Char 167 (.)
    0x00, 0x7C, 0x7C, 0x30, 0x18, 0x7C, 0x7C, 0x00, // Char 168 (.)
    0x00, 0x7C, 0x7C, 0x32, 0x1A, 0x7C, 0x7C, 0x00, // Char 169 (.)
    0x00, 0x7C, 0x7C, 0x10, 0x38, 0x6C, 0x44, 0x00, // Char 170 (.)
    0x00, 0x60, 0x70, 0x18, 0x0C, 0x7C, 0x7C, 0x00, // Char 171 (.)
    0x7C, 0x7C, 0x18, 0x78, 0x18, 0x7C, 0x7C, 0x00, // Char 172 (.)
    0x00, 0x7C, 0x7C, 0x10, 0x10, 0x7C, 0x7C, 0x00, // Char 173 (.)
    0x00, 0x38, 0x7C, 0x44, 0x44, 0x7C, 0x38, 0x00, // Char 174 (.)
    0x00, 0x7C, 0x7C, 0x04, 0x04, 0x7C, 0x7C, 0x00, // Char 175 (.)
    0x00, 0xAA, 0x00, 0x55, 0x00, 0xAA, 0x00, 0x55, // Char 176 (.)
    0xAA, 0x55, 0xAA, 0x55, 0xAA, 0x55, 0xAA, 0x55, // Char 177 (.)
    0x55, 0xFF, 0xAA, 0xFF, 0x55, 0xFF, 0xAA, 0xFF, // Char 178 (.)
    0x00, 0x00, 0x00, 0xFF, 0xFF, 0x00, 0x00, 0x00, // Char 179 (.)
    0x08, 0x08, 0x08, 0xFF, 0xFF, 0x00, 0x00, 0x00, // Char 180 (.)
    0x0A, 0x0A, 0x0A, 0xFF, 0xFF, 0x00, 0x00, 0x00, // Char 181 (.)
    0x08, 0x08, 0xFF, 0xFF, 0x00, 0xFF, 0xFF, 0x00, // Char 182 (.)
    0x08, 0x08, 0xF8, 0xF8, 0x08, 0xF8, 0xF8, 0x00, // Char 183 (.)
    0x0A, 0x0A, 0x0A, 0xFE, 0xFE, 0x00, 0x00, 0x00, // Char 184 (.)
    0x0A, 0x0A, 0xFB, 0xFB, 0x00, 0xFF, 0xFF, 0x00, // Char 185 (.)
    0x00, 0x00, 0xFF, 0xFF, 0x00, 0xFF, 0xFF, 0x00, // Char 186 (.)
    0x0A, 0x0A, 0xFA, 0xFA, 0x02, 0xFE, 0xFE, 0x00, // Char 187 (.)
    0x0A, 0x0A, 0x0B, 0x0B, 0x08, 0x0F, 0x0F, 0x00, // Char 188 (.)
    0x08, 0x08, 0x0F, 0x0F, 0x08, 0x0F, 0x0F, 0x00, // Char 189 (.)
    0x0A, 0x0A, 0x0A, 0x0F, 0x0F, 0x00, 0x00, 0x00, // Char 190 (.)
    0x08, 0x08, 0x08, 0xF8, 0xF8, 0x00, 0x00, 0x00, // Char 191 (.)
    0x00, 0x00, 0x00, 0x0F, 0x0F, 0x08, 0x08, 0x08, // Char 192 (.)
    0x08, 0x08, 0x08, 0x0F, 0x0F, 0x08, 0x08, 0x08, // Char 193 (.)
    0x08, 0x08, 0x08, 0xF8, 0xF8, 0x08, 0x08, 0x08, // Char 194 (.)
    0x00, 0x00, 0x00, 0xFF, 0xFF, 0x08, 0x08, 0x08, // Char 195 (.)
    0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, // Char 196 (.)
    0x08, 0x08, 0x08, 0xFF, 0xFF, 0x08, 0x08, 0x08, // Char 197 (.)
    0x00, 0x00, 0x00, 0xFF, 0xFF, 0x0A, 0x0A, 0x0A, // Char 198 (.)
    0x00, 0x00, 0xFF, 0xFF, 0x00, 0xFF, 0xFF, 0x08, // Char 199 (.)
    0x00, 0x00, 0x0F, 0x0F, 0x08, 0x0B, 0x0B, 0x0A, // Char 200 (.)
    0x00, 0x00, 0xFE, 0xFE, 0x02, 0xFA, 0xFA, 0x0A, // Char 201 (.)
    0x0A, 0x0A, 0x0B, 0x0B, 0x08, 0x0B, 0x0B, 0x0A, // Char 202 (.)
    0x0A, 0x0A, 0xFA, 0xFA, 0x02, 0xFA, 0xFA, 0x0A, // Char 203 (.)
    0x00, 0x00, 0xFF, 0xFF, 0x00, 0xFB, 0xFB, 0x0A, // Char 204 (.)
    0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, // Char 205 (.)
    0x0A, 0x0A, 0xFB, 0xFB, 0x00, 0xFB, 0xFB, 0x0A, // Char 206 (.)
    0x0A, 0x0A, 0x0A, 0x0B, 0x0B, 0x0A, 0x0A, 0x0A, // Char 207 (.)
    0x08, 0x08, 0x0F, 0x0F, 0x08, 0x0F, 0x0F, 0x08, // Char 208 (.)
    0x0A, 0x0A, 0x0A, 0xFA, 0xFA, 0x0A, 0x0A, 0x0A, // Char 209 (.)
    0x08, 0x08, 0xF8, 0xF8, 0x08, 0xF8, 0xF8, 0x08, // Char 210 (.)
    0x00, 0x00, 0x0F, 0x0F, 0x08, 0x0F, 0x0F, 0x08, // Char 211 (.)
    0x00, 0x00, 0x00, 0x0F, 0x0F, 0x0A, 0x0A, 0x0A, // Char 212 (.)
    0x00, 0x00, 0x00, 0xFE, 0xFE, 0x0A, 0x0A, 0x0A, // Char 213 (.)
    0x00, 0x00, 0xF8, 0xF8, 0x08, 0xF8, 0xF8, 0x08, // Char 214 (.)
    0x08, 0x08, 0xFF, 0xFF, 0x08, 0xFF, 0xFF, 0x08, // Char 215 (.)
    0x0A, 0x0A, 0x0A, 0xFF, 0xFF, 0x0A, 0x0A, 0x0A, // Char 216 (.)
    0x08, 0x08, 0x08, 0x0F, 0x0F, 0x00, 0x00, 0x00, // Char 217 (.)
    0x00, 0x00, 0x00, 0xF8, 0xF8, 0x08, 0x08, 0x08, // Char 218 (.)
    0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, // Char 219 (.)
    0xF8, 0xF8, 0xF8, 0xF8, 0xF8, 0xF8, 0xF8, 0xF8, // Char 220 (.)
    0xFF, 0xFF, 0xFF, 0xFF, 0x00, 0x00, 0x00, 0x00, // Char 221 (.)
    0x00, 0x00, 0x00, 0x00, 0xFF, 0xFF, 0xFF, 0xFF, // Char 222 (.)
    0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, // Char 223 (.)
    0x00, 0x7C, 0x7C, 0x24, 0x24, 0x3C, 0x18, 0x00, // Char 224 (.)
    0x00, 0x38, 0x7C, 0x44, 0x44, 0x6C, 0x28, 0x00, // Char 225 (.)
    0x00, 0x04, 0x04, 0x7C, 0x7C, 0x04, 0x04, 0x00, // Char 226 (.)
    0x00, 0x4C, 0x5C, 0x50, 0x50, 0x7C, 0x3C, 0x00, // Char 227 (.)
    0x18, 0x3C, 0x24, 0x7C, 0x7C, 0x24, 0x3C, 0x18, // Char 228 (.)
    0x00, 0x44, 0x6C, 0x38, 0x38, 0x6C, 0x44, 0x00, // Char 229 (.)
    0x00, 0x7C, 0x7C, 0x40, 0x40, 0x7C, 0xFC, 0xC0, // Char 230 (.)
    0x00, 0x0C, 0x1C, 0x10, 0x10, 0x7C, 0x7C, 0x00, // Char 231 (.)
    0x7C, 0x7C, 0x40, 0x7C, 0x7C, 0x40, 0x7C, 0x7C, // Char 232 (.)
    0x7C, 0x7C, 0x40, 0x7C, 0x7C, 0x40, 0xFC, 0xFC, // Char 233 (.)
    0x04, 0x7C, 0x7C, 0x50, 0x50, 0x70, 0x20, 0x00, // Char 234 (.)
    0x7C, 0x7C, 0x50, 0x70, 0x20, 0x7C, 0x7C, 0x00, // Char 235 (.)
    0x00, 0x7C, 0x7C, 0x50, 0x50, 0x70, 0x20, 0x00, // Char 236 (.)
    0x00, 0x44, 0x54, 0x54, 0x54, 0x7C, 0x38, 0x00, // Char 237 (.)
    0x7C, 0x7C, 0x10, 0x38, 0x7C, 0x44, 0x7C, 0x38, // Char 238 (.)
    0x00, 0x48, 0x7C, 0x34, 0x14, 0x7C, 0x7C, 0x00, // Char 239 (.)
    0x54, 0x54, 0x54, 0x54, 0x54, 0x54, 0x54, 0x00, // Char 240 (.)
    0x00, 0x44, 0x44, 0x5F, 0x44, 0x44, 0x00, 0x00, // Char 241 (.)
    0x00, 0x00, 0x82, 0xC6, 0x6C, 0x38, 0x10, 0x00, // Char 242 (.)
    0x00, 0x10, 0x38, 0x6C, 0xC6, 0x82, 0x00, 0x00, // Char 243 (.)
    0x00, 0x00, 0x00, 0xFE, 0xFF, 0x01, 0x07, 0x06, // Char 244 (.)
    0x60, 0xE0, 0x80, 0xFF, 0x7F, 0x00, 0x00, 0x00, // Char 245 (.)
    0x00, 0x10, 0x10, 0xD6, 0xD6, 0x10, 0x10, 0x00, // Char 246 (.)
    0x24, 0x36, 0x12, 0x36, 0x24, 0x36, 0x12, 0x00, // Char 247 (.)
    0x00, 0x0C, 0x1E, 0x12, 0x1E, 0x0C, 0x00, 0x00, // Char 248 (.)
    0x00, 0x00, 0x00, 0x18, 0x18, 0x00, 0x00, 0x00, // Char 249 (.)
    0x00, 0x00, 0x00, 0x10, 0x10, 0x00, 0x00, 0x00, // Char 250 (.)
    0x10, 0x30, 0x60, 0xC0, 0x70, 0x1C, 0x07, 0x01, // Char 251 (.)
    0x3C, 0x42, 0x99, 0xA5, 0xA5, 0x81, 0x42, 0x3C, // Char 252 (.)
    0x00, 0x12, 0x19, 0x15, 0x12, 0x00, 0x00, 0x00, // Char 253 (.)
    0x00, 0x3C, 0x3C, 0x3C, 0x3C, 0x3C, 0x00, 0x00, // Char 254 (.)
    0x00, 0x60, 0x40, 0x40, 0x40, 0x40, 0x60, 0x00  // Char 255 (.)
};

#endif