// -- Example program for the UC1701 library - written for LPC1768

#include "mbed.h"
#include "UC1701.h"

SPI lcd(p5, NC, p7);    // mosi (PIN 9 on LCD), miso (nc), sclk (PIN 8 on LCD)
DigitalOut cs(p8);      // chip select  (active low)
DigitalOut cd(p10);     // command/data (0=command, 1=data) PIN 10 on the LCD (named RS)

UC1701 uc1701(lcd, cs, cd); // Create UC1701 instance

int main()
{
    uc1701.init();
    wait(1);
    uc1701.fill();
    wait(1);
    uc1701.clear();
    wait(1);
    char str[40];
    int n = 6;
    n = sprintf(str, "01234ABCdefghijk");
    while(1) {
        uc1701.drawBitmap(test);
        wait(1);
        uc1701.drawBitmap(einstein);
        wait(1);
        uc1701.drawBitmap(biohazard);
        wait(1);
        uc1701.drawBitmap(highvoltage);
        wait(1);
        uc1701.drawBitmap(copter);
        wait(1);
        uc1701.clear();
        uc1701.clearBuffer();
        uc1701.drawbufferLineHor(10, 7, 4, 108);
        uc1701.drawbufferLineVert(62, 7, 55, 4);
        uc1701.update();
        wait(1);
        //uc1701.drawLineVert(62, 10, 40, 4);
        //wait(5);        
        uc1701.clear();
        uc1701.writeText(0,0, font_6x6, str, n);
        uc1701.writeText(0,1, font_7x7, str, n);
        uc1701.writeText(0,2, bold_font, str, n);
        uc1701.writeText(0,3, font_5x8, str, n);
        uc1701.writeText2d(0,4, font2d_hunter, str, n);
        uc1701.writeText(0,5, font_8x8_1, str, n);
        uc1701.writeText2d(0,6, font2d_formplex12, str, n);
        uc1701.writeText(0,7, font_4x5, str, n);
        wait(5);
    }
}
