// Coded by Erik van de Coevering 
// DSP-style low-pass IIR filters designed with Matlab's FDAtool. 
// For information on how to implement these filters, check this pdf: http://spinlab.wpi.edu/courses/ece4703_2009/how_to_interpret_matlab_dfii_sos.pdf

#include "LPfilter.h"
/*
float LPfilter::run(float input) {
	filterbuffer[2] = filterbuffer[1];
	filterbuffer[1] = filterbuffer[0];
	filterbuffer[0] = input*LP_A + filterbuffer[1]*LP_B + filterbuffer[2]*LP_C;

	out = filterbuffer[0]*LP_D + filterbuffer[1]*LP_E + filterbuffer[2]*LP_F;
	return out;
}

float LPfilter2::run(float input) {
	filterbuffer1[2] = filterbuffer1[1];
	filterbuffer1[1] = filterbuffer1[0];
	filterbuffer1[0] = input*0.003762202981699 + filterbuffer1[1]*1.893415601023 + filterbuffer1[2]*-0.9084644129493;
	
	out_temp = filterbuffer1[0] + filterbuffer1[1]*2.0f + filterbuffer1[2];
	
	filterbuffer2[2] = filterbuffer2[1];
	filterbuffer2[1] = filterbuffer2[0];
	filterbuffer2[0] = out_temp*0.003533495923378 + filterbuffer2[1]*1.778313488139 + filterbuffer2[2]*-0.7924474718329;
	
	out = filterbuffer2[0] + filterbuffer2[1]*2.0f + filterbuffer2[2];
	return out;
}

float LPfilter2_1::run(float input) {
	filterbuffer1[2] = filterbuffer1[1];
	filterbuffer1[1] = filterbuffer1[0];
	filterbuffer1[0] = input*0.007954132308248 + filterbuffer1[1]*1.836787188551 + filterbuffer1[2]*-0.8686037177835;
	
	out_temp = filterbuffer1[0] + filterbuffer1[1]*2.0f + filterbuffer1[2];
	
	filterbuffer2[2] = filterbuffer2[1];
	filterbuffer2[1] = filterbuffer2[0];
	filterbuffer2[0] = out_temp*0.007277930990548 + filterbuffer2[1]*1.680637168775 + filterbuffer2[2]*-0.7097488927369;
	
	out = filterbuffer2[0] + filterbuffer2[1]*2.0f + filterbuffer2[2];
	return out;
}
*/
//8th order IIR filter, with Fs = 1500Hz and Fc = 45Hz

float LPfilter8::run(float input) {
	filterbuffer1[2] = filterbuffer1[1];
	filterbuffer1[1] = filterbuffer1[0];
	filterbuffer1[0] = input*0.008544036438708 + filterbuffer1[1]*1.895289756537 + filterbuffer1[2]*-0.9294659022914;
	
	out_temp1 = filterbuffer1[0] + filterbuffer1[1]*2.0f + filterbuffer1[2];
	
	filterbuffer2[2] = filterbuffer2[1];
	filterbuffer2[1] = filterbuffer2[0];
	filterbuffer2[0] = out_temp1*0.008021326615853 + filterbuffer2[1]*1.779339107215 + filterbuffer2[2]*-0.811424413678;
	
	out_temp2 = filterbuffer2[0] + filterbuffer2[1]*2.0f + filterbuffer2[2];
	
	filterbuffer3[2] = filterbuffer3[1];
	filterbuffer3[1] = filterbuffer3[0];
	filterbuffer3[0] = out_temp2*0.007662537043122 + filterbuffer3[1]*1.699750237618 + filterbuffer3[2]*-0.7304003857905;
	
	out_temp3 = filterbuffer3[0] + filterbuffer3[1]*2.0f + filterbuffer3[2];
	
	filterbuffer4[2] = filterbuffer4[1];
	filterbuffer4[1] = filterbuffer4[0];
	filterbuffer4[0] = out_temp3*0.007481430998498 + filterbuffer4[1]*1.659576201179 + filterbuffer4[2]*-0.6895019251732;
	
	out = filterbuffer4[0] + filterbuffer4[1]*2.0f + filterbuffer4[2];
	
	return out;
}
