// Written by: Erik van de Coevering 

#ifndef __LSM9DS1_SPI_H__
#define __LSM9DS1_SPI_H__

#include "mbed.h"

class lsm9ds1_spi
{
        SPI& spi;
        DigitalOut csAG;
        DigitalOut csM;
    
    public:
        lsm9ds1_spi(SPI& _spi, PinName _csAG, PinName _csM);
        unsigned int WriteRegAG(uint8_t WriteAddr, uint8_t WriteData);
        unsigned int WriteRegM(uint8_t WriteAddr, uint8_t WriteData);
        unsigned int ReadRegAG(uint8_t WriteAddr, uint8_t WriteData);
        unsigned int ReadRegM(uint8_t WriteAddr, uint8_t WriteData);
        void ReadRegsAG(uint8_t ReadAddr, uint8_t *ReadBuf, unsigned int Bytes );
        void ReadRegsM(uint8_t ReadAddr, uint8_t *ReadBuf, unsigned int Bytes );
    
        void selectAG();
        void selectM();
        void deselectAG();
        void deselectM();
    
        void init();
        unsigned int whoami();
        unsigned int whoamiM();
        float read_temp();      // reads temperature in degrees C
        void read_acc();        // reads accelerometer in G
        void read_gyr();        // reads gyroscope in DPS
        void read_mag();        // reads magnetometer in gauss
        void read_all();        // reads acc / gyro / magneto
    
        float acc_multiplier;
        float gyro_multiplier;
        float mag_multiplier;
        float accelerometer_data[3];
        float gyroscope_data[3];
        float magnetometer_data[3];
    
};

#define FS_G_245DPS         0x00
#define FS_G_500DPS         0x08
#define FS_G_2000DPS        0x18
#define ODR_G_15HZ          0x20
#define ODR_G_60HZ          0x40
#define ODR_G_119HZ         0x60
#define ODR_G_238HZ         0x80
#define ODR_G_476HZ         0xA0
#define ODR_G_952HZ         0xC0
#define BW_G_33HZ           0x00    // Bandwidth dependant on ODR, these freq's are correct for ODR=476Hz or 952Hz. Check datasheet for other ODR's
#define BW_G_40HZ           0x01
#define BW_G_58HZ           0x02
#define BW_G_100HZ          0x03
#define FS_A_2G             0x00
#define FS_A_4G             0x10
#define FS_A_8G             0x18
#define FS_A_16G            0x08
#define FS_M_4GAUSS         0x00
#define FS_M_8GAUSS         0x20    
#define FS_M_12GAUSS        0x40
#define FS_M_16GAUSS        0x60

#define ACC_SENS_2G         0.000061f
#define ACC_SENS_4G         0.000122f
#define ACC_SENS_8G         0.000244f
#define ACC_SENS_16G        0.000732f
#define GYR_SENS_245DPS     0.00875f
#define GYR_SENS_500DPS     0.0175f
#define GYR_SENS_2000DPS    0.07f
#define MAG_SENS_4GAUSS     0.00014f
#define MAG_SENS_8GAUSS     0.00029f
#define MAG_SENS_12GAUSS    0.00043f
#define MAG_SENS_16GAUSS    0.000732f

#define READ_FLAG 0x80  

#endif


