#include "mbed.h"
#include "LSM9DS1_SPI.h"

SPI spi(p11, p12, p13); //mosi, miso, sclk
lsm9ds1_spi lsm9ds1(spi, p14, p21); //spi, CS_ag, CS_m
Serial pc(USBTX, USBRX);

int main() {    
    float temp = 0;
    lsm9ds1.init();
    
    while(1) {
        temp = lsm9ds1.read_temp();
        lsm9ds1.read_all();
        pc.printf("Accelerometer values: \r\n");
        pc.printf("x:%.2f     y:%.2f        z:%.2f\r\n", lsm9ds1.accelerometer_data[0], lsm9ds1.accelerometer_data[1], lsm9ds1.accelerometer_data[2]);
        pc.printf("Gyro values: \r\n");
        pc.printf("x:%.2f     y:%.2f        z:%.2f\r\n", lsm9ds1.gyroscope_data[0], lsm9ds1.gyroscope_data[1], lsm9ds1.gyroscope_data[2]);
        pc.printf("Magnetometer values: \r\n");
        pc.printf("x:%.2f     y:%.2f        z:%.2f\r\n", lsm9ds1.magnetometer_data[0], lsm9ds1.magnetometer_data[1], lsm9ds1.magnetometer_data[2]);
        pc.printf("And last but not least, it's %.2f degrees celcius.\r\n", temp);
        wait(1);
    }
}
