/* 
        GRAEST - GRUPO DE ROBÓTICA E AUTOMAÇÃO DA ESCOLA SUPERIOR DE TECNOLOGIA
    
    Produto: Software de controle para esteira
    Contratante: Denso
    Lincença: Paga
    Responsáveis: Fabrício Guimarães
                                Kedson Pinheiro
                                Marcel Cunha
                                Rafael Facccione

*/

#include "mbed.h"
#include "EthernetInterface.h"
#include "stdio.h"
#include "stdlib.h"
#include "string.h"


// Protocolo I2C 
I2C i2c(p28, p27);
// Endereço do Servidor
const char* ECHO_SERVER_ADDRESS = "192.168.0.101";
const int ECHO_SERVER_PORT = 25;

// Sensor de presença // Botõe de Inicio e Emergência
DigitalIn BotaoInicio(p8);
DigitalIn BotaoEmergencia(p22);
DigitalIn sensorParada1(p16);
DigitalIn sensorParada2(p17);
DigitalIn sensorParada3(p18);


DigitalIn teste1(p5);
DigitalIn teste2(p6);

// Movimento Esteira 
DigitalOut movimentoEsteira1(p21);
DigitalOut movimentoEsteira2(p22);

// Movimento Pneumático

DigitalOut movimentoPneumatico(p7);

//Leds
//DigitalOut l1(p9);
//DigitalOut l2(p10);

DigitalOut myled1(LED1);
DigitalOut myled2(LED2);

// /*
//      FUNCTION *dec_bin:: converter inteiro em binário 
//      EX:  *dec_bin ( int dec ){ 
//      Variaveis: dec (int)
//                          
// */
char *dec_bin ( int dec ){

     char *bin = (char *) malloc ( 9 * sizeof(char)); // binario 8-bits
     register int i;

     for ( i = 0; i < 8; i++ )
         bin[i] = ( dec & (128 >> i)) ? '1' : '0';

     bin[8] = 0x0;

     return bin;
}

int main() {
    // Endereço PCF's
     int address1=112;
     int address2=114;
     int address3=116;
     int address4=118;
     char pcf[1]={0};
     char *c;

   // Mbed Ip 
     EthernetInterface eth;
     static const char* mbedIp = "192.168.0.102";
     static const char* mbedMask = "255.255.255.0";
     static const char* mbedGatway = "192.168.0.1";
    
     eth.init(mbedIp,mbedMask,mbedGatway); //Use DHCP
     eth.connect();
     printf("\nClient IP Address is %s\n", eth.getIPAddress());

    // Connect to Server
     TCPSocketConnection socket;
     while (socket.connect(ECHO_SERVER_ADDRESS, ECHO_SERVER_PORT) < 0) {
        printf("Unable to connect to (%s) on port (%d)\r\n", ECHO_SERVER_ADDRESS, ECHO_SERVER_PORT);
        
     }
     printf("Connected to Server at %s\r\n",ECHO_SERVER_ADDRESS);
    
     char A[] = "esteiraLivre\n";
     char B[] = "esteiraPronta\n";
     char C[] = "esteiraOcupada\n";
     char D[] = "esteiraSegundaOpcao\n";
     char E[] = "terceiraPosicao\n";
     char F[] = "botaoAcionado\n";
     char T[] = "11111111000000111111111100000011#\n";
     char G[] = "voltandoPosicao1\n";
     char H[]="EmergenciaAcionada\n";
        
     int flagErro;
     int flagSucesso;
     int etapa;
     int flagA;
     int flagB;
     int flagC;
     int flagF;

     while(true) {
            flagErro=0;
            etapa=0;
            int a1 = sensorParada1.read();
            int a2 = sensorParada2.read();
            int a3 = sensorParada3.read();
            int flagEmergencia = BotaoEmergencia.read();

           /////////////////////////////////////////////////////////////////////////
          // etapa 1 : Etapa de aguardo do clique do botao de inicio de atividade//
         //           Envio de mensagem para o Java se paradas obstruidas       //
        /////////////////////////////////////////////////////////////////////////
            
            while(a1==1&a2==0&&a3==0&&flagEmergencia==0){
                  a1 = sensorParada1.read();
                  a2 = sensorParada2.read();
                  a3 = sensorParada3.read();
                  flagEmergencia = BotaoEmergencia.read();

                  int flagEstadoBotao=BotaoInicio.read();
               //Enviando Mensagem ao servidor
                
//                if(flagB==0){
//                    socket.send_all(B, sizeof(B));
//                    printf("Esteira etapa 1\r\n");
//              
//                }
                  if(flagEstadoBotao==1){
                     
                     if(flagF==0){
                        socket.send_all(F, sizeof(F));
                        //mandar a esteira ir pra frente

                     }
                     movimentoEsteira1=1;
                     movimentoEsteira2=0;
                     etapa=3;    
                  }
           }
            
                
             if(sensorParada1.read()==0&&sensorParada2==0&&sensorParada3==0){
                
                socket.send_all(A, sizeof(A));
                printf("Sending  message to Server : %s size:%d\r\n",A,sizeof(A));
                printf("Esteira Livre\r\n");
                //Esteira Parada
                movimentoEsteira1=0;
                movimentoEsteira2=0;
                
             }
            
             else {
                socket.send_all(C, sizeof(C));
                printf("Sending  message to Server : %s size:%d\r\n",C,sizeof(C));
                printf("Esteira ocupada\r\n");
                //Esteira Parada
                movimentoEsteira1=0;
                movimentoEsteira2=0;
    
             }
                
            ///////////////////////////////////////////////////////////////////////////////////
            //etapa 2 : Etapa onde  sensor do meio aguarda a caixa, se obstruido esteira para//
            ///////////////////////////////////////////////////////////////////////////////////
            
            while(etapa==2){
                
                
                printf("Iniciando movimento r\n");
        
                if(sensorParada2.read()==1){
                    int b1=teste1.read();
                    int b2=teste2.read();
                    printf("Esteira parada, caixa em posicao \r\n");
                    socket.send_all(D, sizeof(D));
                    
                    //mandar parar esteira 
                    movimentoEsteira1=0;
                    movimentoEsteira2=0;
                    //lendo os sensores pneumaticos de Inicio e fim de curso 
                    i2c.read(address4, pcf, 1);
                    i2c.stop();
                    c=dec_bin(pcf[0]);
                    //OBS : ANALISAR A POSIÇÃO DA CAIXA NA ESTEIRA
                    //if(c[4]==1 &&c[3]==0){
                    if(b1==1&&b2==0){
                        movimentoPneumatico =1;
                        printf("pistao acionado");

                    }
                    
                    // A validação dos sensores só ocorrera se o sensor de fim de curso estiver ativado
                    //if(c[4]==0 &&c[3]==1){
                    if(b1==0&&b2==1){
                        printf("pistao na posicao fim ");
                        etapa=3;    
                    }
                }
            }
        
        //////////////////////////////////////////////////////////////////////////////
        //etapa 3 : Avaliando os Sensores de magntezição e de presença//
        //////////////////////////////////////////////////////////////////////////////
//      

        
     while(etapa== 3){
                
        printf("iniciando Teste");
                
       //TODO comunicação com o CI; envio para o java e validação
        int i=0;
        int resultado;
        char pcf1[1]={0};
        char pcf2[1]={0};
        char pcf3[1]={0};
        char pcf4[1]={0};
        char buf[256];
        char *c1;
        char *c2;
        char *c3;
        char *c4;
        char f1[16];
        char f2[24];
        char f3[34];

        while(i<4){
            // Iniciando Leitura dos PCF1
            i2c.read(address1, pcf1, 1);
            i2c.stop();
            c1=dec_bin(pcf1[0]);
        
            // Iniciando Leitura dos PCF2
            i2c.read(address2, pcf2, 1);
            i2c.stop();
            c2=dec_bin(pcf2[0]);
        
            // Iniciando Leitura dos PCF3
            i2c.read(address3, pcf3, 1);
            i2c.stop();
            c3=dec_bin(pcf3[0]);
        
            // Iniciando Leitura dos PCF4
            i2c.read(address4, pcf4, 1);
            i2c.stop();
            c4=dec_bin(pcf4[0]);
 
            // Ralizando a concatenação do vetor
            strcpy(f1,strcat(c3,c4));
            strcpy(f2,strcat(c2,f1));
            strcpy(f3,strcat(c1,f2));
    
            //Adicionando /n ao final do vetor
            f3[32]='#';
            f3[33]='\n';

            printf("Valor=%s=====\r\n",f3);
         
            //Enviando amostras ao Servidor
            //socket.send_all(f3,34);
            socket.send_all(T, sizeof(T));
            //wait(1);
            i++;
            etapa=4;
        }
 
//  while(i<500){
//   
//   if(i>1000){
//       socket.send_all(f3,34);
//       
//   }
//   i++;
//  }
     
     //Recebendo a resposta do Servidor
//       int a=socket.receive(buf,256);
//   buf[a]='\0';
//   printf("A palavra recebida e %s\r\n",buf); 
//       resultado =strncmp(buf,"1",1);
    //O Pistão volta a posição inicial
//   movimentoPneumatico=0;
//   //Avaliando a reposta do servidor
//   if (resultado==0){
//           printf("Sucesso");
//        etapa=4;
//       flagSucesso=1;
//   }else{
//        printf("Error");
//    etapa=4;
//        flagErro=1;
//    }
//  }
//           ///////////////////////////////////////////////////
//          //etapa Erro: A Esteira indo para a primeira posição//
//          //  
//          ///////////////////////////////////////////////////////
//  
//              while(flagErro==1){
//          int b1=teste1.read();
//                  
//          char *e;
//          a1 = sensorParada1.read();
//              printf("error");
//          
//          socket.send_all(G, sizeof(G));
//              
//      //lendo os sensores pneumaticos
//       i2c.read(address4, pcf, 1);
//      i2c.stop();
//       e=dec_bin(pcf[0]);
//              
//      //Só irá andar caso o pistão esteja na posição inicial e não estiver caixa na posiçãoo 1
//              //if(e[4]==1&&a1==0){
//                  if(b1==1&&a1==0){
//          //mandar esteira para trás
//        movimentoEsteira1=1;
//          movimentoEsteira2=1;
//          }
//          
//              if(a1==1){  
//                  flagErro=0;
//                  //Esteira Parada
//          movimentoEsteira1=0;
//                  movimentoEsteira2=0;
//                  
//              }
//              
//          }
//          
//          ///////////////////////////////////////////////////////
//          //etapa Sucesso: A Esteira indo para a terceira posição//
//          //  
//          ///////////////////////////////////////////////////////
//          
//  while(flagSucesso == 1){
//  printf("sucesso");
//  char *f;
//  a3 = sensorParada3.read();
//  
//  //lendo os sensores pneumaticos
//  i2c.read(address4, pcf, 1);
//   i2c.stop();
//  f=dec_bin(pcf[0]);
//      
//  //So irá andar quando o pistao estiver na posição inicial 
//  // Movimentando a esteira para frente
//        if(f[4]==1&&a3==0){
//      movimentoEsteira1=1;
//      movimentoEsteira2=0;
//          }
//      
//      while(a3==1){
//      // Parando a esteira
//      movimentoEsteira1=0;
//      movimentoEsteira2=0;
//  //OBS: ANALISAR TEMPO DE PARADA
//  socket.send_all(E, sizeof(E));
//      printf("Retirar a caixa");
//      flagSucesso=0;
//      }
// //     // Clean up
// //    // socket.close();
// //     //eth.disconnect();

//  }
//    

// //Se botao emergencia ativado esteira permanece parada
//  if(flagEmergencia==1){
//      movimentoEsteira1=0;
//      movimentoEsteira2=0;
//      //enviando mensagem ao servidor
//      socket.send_all(H, sizeof(H));
//  
//  }
// }
}
}
}