#include "Ambient.h"

#define _DEBUG 0

#if _DEBUG
#define DBG(...) { printf(__VA_ARGS__); }
#define ERR(...) { printf(__VA_ARGS__); }
#else
#define DBG(...)
#define ERR(...)
#endif /* _DBG */

const char* AMBIENT_HOST = "54.65.206.59";
const int AMBIENT_PORT = 80;
const char* AMBIENT_HOST_DEV = "192.168.0.8";
const int AMBIENT_PORT_DEV = 4567;

const char * ambient_keys[] = {"\"d1\":\"", "\"d2\":\"", "\"d3\":\"", "\"d4\":\"", "\"d5\":\"", "\"d6\":\"", "\"d7\":\"", "\"d8\":\"", "\"lat\":\"", "\"lng\":\"", "\"created\":\""};

Ambient::Ambient() {
}

bool
Ambient::init(unsigned int channelId, const char * writeKey, TCPSocketConnection * s, int dev) {
    this->channelId = channelId;

    if (sizeof(writeKey) > AMBIENT_WRITEKEY_SIZE) {
        ERR("writeKey length > AMBIENT_WRITEKEY_SIZE");
        return false;
    }
    strcpy(this->writeKey, writeKey);

    if(NULL == s) {
        ERR("Socket Pointer is NULL, open a socket.");
        return false;
    }
    this->s = s;
    this->dev = dev;
    if (dev) {
        strcpy(this->host, AMBIENT_HOST_DEV);
        this->port = AMBIENT_PORT_DEV;
    } else {
        strcpy(this->host, AMBIENT_HOST);
        this->port = AMBIENT_PORT;
    }
    for (int i = 0; i < AMBIENT_NUM_PARAMS; i++) {
        this->data[i].set = false;
    }
    return true;
}

bool
Ambient::set(int field, char * data) {
    --field;
    if (field < 0 || field >= AMBIENT_NUM_PARAMS) {
        return false;
    }
    if (strlen(data) > AMBIENT_DATA_SIZE) {
        return false;
    }
    this->data[field].set = true;
    strcpy(this->data[field].item, data);

    return true;
}

bool
Ambient::clear(int field) {
    --field;
    if (field < 0 || field >= AMBIENT_NUM_PARAMS) {
        return false;
    }
    this->data[field].set = false;

    return true;
}

bool
Ambient::send() {

    int retry;
    for (retry = 0; retry < AMBIENT_MAX_RETRY; retry++) {
        int ret;
        ret = this->s->connect(this->host, this->port);
        if (ret == 0) {
            break ;
        }
    }
    if(retry == AMBIENT_MAX_RETRY) {
        ERR("Could not connect socket to host\r\n");
        return false;
    }

    char str[360] = {0};
    char header[54] = {0};
    char host[32] = {0};
    char contentLen[28] = {0};
    const char *contentType = "Content-Type: application/json\r\n\r\n";
    char body[192] = {0};

    strcat(body, "{\"writeKey\":\"");
    strcat(body, this->writeKey);
    strcat(body, "\",");

    for (int i = 0; i < AMBIENT_NUM_PARAMS; i++) {
        if (this->data[i].set) {
            strcat(body, ambient_keys[i]);
            strcat(body, this->data[i].item);
            strcat(body, "\",");
        }
    }
    body[strlen(body) - 1] = '\0';

    strcat(body, "}\r\n");

    sprintf(header, "POST /api/v2/channels/%d/data HTTP/1.1\r\n", this->channelId);
    if (this->port == 80) {
        sprintf(host, "Host: %s\r\n", this->host);
    } else {
        sprintf(host, "Host: %s:%d\r\n", this->host, this->port);
    }
    sprintf(contentLen, "Content-Length: %d\r\n", strlen(body));
    sprintf(str, "%s%s%s%s%s", header, host, contentLen, contentType, body);

    DBG("sending: %d bytes\r\n%s", strlen(str), str);

    int ret;
    ret = this->s->send_all(str, strlen(str));
    wait_ms(30);
    DBG("%d bytes sent\r\n", ret);
    if (ret < 0) {
        ERR("send failed\r\n");
        return false;
    }

    ret = this->s->receive(str,sizeof(str));
    str[ret]=0;
    DBG("Received String : (%d)\r\n%s\r\n",ret, str);

    this->s->close();

    for (int i = 0; i < AMBIENT_NUM_PARAMS; i++) {
        this->data[i].set = false;
    }

    return true;
}
