/*
 * Every 5 seconds, send the BPM value to Ambient.
 * Turn on and off the LED.
 */
#include "mbed.h"
#include "math.h"
#include "ESP8266Interface.h"
#include "TCPSocketConnection.h"
#include "SoftSerialSendOnry.h"
#include "Ambient.h"

ESP8266Interface wifi(dp16,dp15,dp4,"ssid","password",115200); // TX,RX,Reset,SSID,Password,Baud

SoftSerialSendOnry pc(dp10);

unsigned int channelId = 100;
const char* writeKey = "ライトキー";
Ambient ambient;

extern void interruptSetup();

// Volatile Variables, used in the interrupt service routine!
extern volatile bool QS;                        // becomes true when Arduoino finds a beat.
extern volatile int BPM;                           // int that holds raw Analog in 0. updated every 2mS

int main() {
    TCPSocketConnection socket;

    pc.baud(9600);

    wifi.init(); //Reset
    wifi.connect(); //Use DHCP
    pc.printf("IP Address is %s\r\n", wifi.getIPAddress());
    ambient.init(channelId, writeKey, &socket);
    
    interruptSetup();

    while (true) {
        char bpmbuf[12];

        if (QS == true){                    // A Heartbeat Was Found
                                            // BPM and IBI have been Determined
                                            // Quantified Self "QS" true when mbed finds a heartbeat
            sprintf(bpmbuf, "%3d", BPM);
            pc.printf("BPM:%s\r\n", bpmbuf);
            ambient.set(1, bpmbuf);
            ambient.send();

            QS = false;                     // reset the Quantified Self flag for next time    
        }
        wait(5);                           //  take a break
    }
}
