/*
 * while (true) {
 *     clear data.
 *     sample heart pulse every 25m seconds, 28 times.
 *     send data to Ambient.
 *     wait 2 seconds.
 */
#include "mbed.h"
#include "math.h"
#include "ESP8266Interface.h"
#include "TCPSocketConnection.h"
#include "SoftSerialSendOnry.h"
#include "Ambient.h"

#define SAMPLING 25         //  Sampling period in milliseconds
                            //  When BPM is 100, IBI is 600msec and we have 30 samples.
#define NSAMPLES 35         //  Number of Samples
#define BUFSIZE  1050

ESP8266Interface wifi(dp16,dp15,dp4,"ssid","password",115200); // TX,RX,Reset,SSID,Password,Baud

SoftSerialSendOnry pc(dp10);
DigitalOut led(dp6);

unsigned int channelId = 100;
const char* userKey = "ユーザーキー";
const char* writeKey = "ライトキー";
Ambient ambient;

AnalogIn pulsePin(dp13);
Ticker t2;
volatile int done = false;
unsigned short signal[NSAMPLES];
char buffer[BUFSIZE];
volatile int sampleIndex = 0;

void sampling() {
    led = 1;
    signal[sampleIndex++] = pulsePin.read_u16();
    if (sampleIndex >= NSAMPLES) {
        done = true;
    }
}

int main() {
    TCPSocketConnection socket;

    pc.baud(9600);
    pc.printf("start\r\n");
    wifi.init(); //Reset
    wifi.connect(); //Use DHCP
    pc.printf("IP Address is %s\r\n", wifi.getIPAddress());
    ambient.init(channelId, writeKey, &socket);
    led = 0;

    while (true) {
        pc.printf("sampling start...");
        done = false;
        sampleIndex = 0;
        t2.attach_us(&sampling, SAMPLING * 1000.0f);
        while (!done) {
            ;
        }
        t2.detach();
        pc.printf("done\r\n");
        led = 0;
    
        sprintf(buffer, "{\"writeKey\":\"%s\",\"data\":[", writeKey);
        for (int i = 0; i < NSAMPLES; i++) {
            sprintf(&buffer[strlen(buffer)], "{\"created\":%d,\"d%d\":%d},", SAMPLING * i, 2, signal[i]);
        }
        buffer[strlen(buffer)-1] = '\0';
        sprintf(&buffer[strlen(buffer)], "]}\r\n");
        
        ambient.delete_data(userKey);

        int sent = ambient.bulk_send(buffer);
        pc.printf("%d bytes sent\r\n", sent);

        wait(5);
    }
}
