#include "mbed.h"
#include "math.h"
#include "ESP8266Interface.h"
#include "TCPSocketConnection.h"
#include "SoftSerialSendOnry.h"

#include "Ambient.h"

ESP8266Interface wifi(dp16,dp15,dp4,"SSID","Password",115200); // TX,RX,Reset,SSID,Password,Baud

unsigned int channelId = 100;
const char* writeKey = "ライトキー";
Ambient ambient;

AnalogIn thermistor(dp13);
const int B=4275; // B value of the thermistor

SoftSerialSendOnry pc(dp10);

int main()
{
    TCPSocketConnection socket;

    pc.baud(9600);

    wifi.init(); //Reset
    wifi.connect(); //Use DHCP
    pc.printf("IP Address is %s\r\n", wifi.getIPAddress());

    ambient.init(channelId, writeKey, &socket);

    while (true) {
        float temp;
        char tempbuf[12];
        int a = thermistor.read_u16();
        
        float R = 65535.0/((float)a)-1.0;
        R = 100000.0*R;

        //convert to temperature via datasheet ;
        temp = 1.0/(log(R/100000.0)/B+1/298.15)-273.15;
        
        pc.printf("%4.2f\r\n", temp);

        sprintf(tempbuf, "%2.1f", temp);
        ambient.set(1, tempbuf);

        ambient.send();

        wait(30.0);
    }
}
