#include "mbed.h"
#include "EthernetInterface.h"
#include "Ambient.h"
#include "HDC1000.h"

unsigned int channelId = 517;
const char* writeKey = "0f63cc33c424afd0";
Ambient ambient;

HDC1000      hdc1000(p9,p10);

int main() {
    printf("start\r\n");

    EthernetInterface eth;
    eth.init();
    eth.connect();

    TCPSocketConnection socket;
    ambient.init(channelId, writeKey, &socket);

    printf("\n\rClient IP Address is %s\n\r", eth.getIPAddress());
    printf("Ambient send to ch: %d\r\n", channelId);

    while (true) {
        float temp, humid;
        char humidbuf[12];

        hdc1000.get();
        temp = hdc1000.temperature();
        humid = hdc1000.humidity();

        printf("temp= %2.0f, humid= %2.0f\r\n", temp, humid);

        ambient.set(1, temp);
        snprintf(humidbuf, sizeof(humidbuf), "%2.0f", humid);
        ambient.set(2, humidbuf);

        ambient.send();
        
        wait(300.0);
    }
}
