#include "mbed.h"
#include "HCSR04.h"
//  https://developer.mbed.org/users/Nestordp/code/HC-SR04/

Serial pc(USBTX, USBRX);
Ticker Ultrasonic; // Ultrasonic Sensor   https://developer.mbed.org/handbook/Ticker
HCSR04 us(D12, D13); //SRF05(PinName trigger, PinName echo)
DigitalOut selectB(D6);
DigitalOut selectA(D5);
DigitalOut selectb(D4);
DigitalOut selecta(D3);
#define d1 5
#define d2 20
#define d3 35
#define d4 50
int range[12] = {0};
float dis = 0;

void US()
{   
        int i = 0;
        for( i = 0; i <= 11; i++)
        {
            switch(i)
            {
                case 0:  //  b=0 a=0 B=0 A=0 Board1
                    selectb = 0;
                    selecta = 0;
                    selectB = 0;
                    selectA = 0;
                    break;
                case 1:  //  b=0 a=0 B=0 A=1 Board1
                    selectb = 0;
                    selecta = 0;
                    selectB = 0;
                    selectA = 1;
                    break;
                case 2:  //  b=0 a=0 B=1 A=0 Board1
                    selectb = 0;
                    selecta = 0;
                    selectB = 1;
                    selectA = 0;
                    break;
                case 3:  //  b=0 a=0 B=1 A=1 Board1
                    selectb = 0;
                    selecta = 0;
                    selectB = 1;
                    selectA = 1;
                    break;
                case 4:  //  b=0 a=1 B=0 A=0 Board2
                    selectb = 0;
                    selecta = 1;
                    selectB = 0;
                    selectA = 0;
                    break;
                case 5:  //  b=0 a=1 B=0 A=1 Board2
                    selectb = 0;
                    selecta = 1;
                    selectB = 0;
                    selectA = 1;
                    break;
                case 6:  //  b=0 a=1 B=1 A=0 Board2
                    selectb = 0;
                    selecta = 1;
                    selectB = 1;
                    selectA = 0;
                    break;
                case 7:  //  b=0 a=1 B=1 A=1 Board2
                    selectb = 0;
                    selecta = 1;
                    selectB = 1;
                    selectA = 1;
                    break;
                case 8:  //  b=1 a=0 B=0 A=0 Board3
                    selectb = 1;
                    selecta = 0;
                    selectB = 0;
                    selectA = 0;
                    break;
                case 9:  //  b=1 a=0 B=0 A=1 Board3
                    selectb = 1;
                    selecta = 0;
                    selectB = 0;
                    selectA = 1;
                    break;
                case 10:  //  b=1 a=0 B=1 A=0 Board3
                    selectb = 1;
                    selecta = 0;
                    selectB = 1;
                    selectA = 0;
                    break;
                case 11:  //  b=1 a=0 B=1 A=1 Board3
                    selectb = 1;
                    selecta = 0;
                    selectB = 1;
                    selectA = 1;
                    break;
            }
            dis = us.getCm();
            if ( dis >= 0 && dis < d1)
            {
                range[i] = 0;
            }
            else if ( dis >= d1 && dis < d2)
            {
                range[i] = 1;
            }
            else if ( dis >= d2 && dis < d3)
            {
                range[i] = 2;
            }
            else if ( dis >= d3 && dis <= d4)
            {
                range[i] = 3;
            }
            else
            {
                range[i] = 4;
            }
        }
        //printf(" %d | %d | %d | %d --- %d | %d | %d | %d --- %d | %d | %d | %d \n", range[0], range[1], range[2], range[3], range[4], range[5], range[6], range[7], range[8], range[9], range[10], range[11]);
}

int main()
{
    pc.baud(115200);
    Ultrasonic.attach(&US, 0.5); // the address of the function to be attached (US) and the interval (0.4 seconds)
    while(1) 
    {
        printf(" %d | %d | %d | %d --- %d | %d | %d | %d --- %d | %d | %d | %d \n", range[0], range[1], range[2], range[3], range[4], range[5], range[6], range[7], range[8], range[9], range[10], range[11]);
        wait(2);
    }
}





 