#include "mbed.h"
#include "stepper.h"
#include <cmath>


//------------------------------------
// Hyperterminal configuration
// 9600 bauds, 8-bit data, no parity
//------------------------------------


typedef enum {
    PointerS,PointerW,PointerX,PointerY,PointerZ,PointerA,PointerL,PointerWW,PointerP
} STATE;                     //定义结构体枚举类型STATE


Serial pc(PA_9, PA_10);    //定义引脚
Serial bt(PB_10, PB_11);

stepperMotor motorX(PC_5, PC_4, PD_2, PC_8, 0.0002);
stepperMotor motorY(PA_5, PA_4, PA_2, PA_6, 0.0002);
stepperMotor motorZ(PC_3, PC_2, PC_13, PC_6, 0.0002);
//DigitalIn swX(PA_6);
//DigitalIn swY(PA_6);
//DigitalIn swZ(PA_6);
float X1 , X2 , Y1 , Y2 , Z , A;              // 定义浮点数值用以储存返回给机械臂的执行步数
const char* strX;                 //定义全局变量X,Y,Z,A字符串指针
const char* strY;
const char* strZ;
const char* strA;
int remainX = 0 ;
int remainY = 0 ;
int remainZ = 0;
//stringstream ss;
char buf[256];
int cur;
bool received;
bool flagx, flagy , flagz , flaga , flagw , flagp;
int countL = 0;
float Arr[20][4];
int counter = 0; 

//void init()        //复位函数
//{
//    stepperMotor motorX(PC_5, PC_4, PD_2, PC_8, 0.0005);
//    stepperMotor motorY(PA_5, PA_4, PA_2, PA_6, 0.0005);
//    stepperMotor motorZ(PC_3, PC_2, PC_13, PC_6, 0.0005);      //复位速度要变慢
//    int steps = -12000;
//    motorX.enable(steps);
//    while(motorX.remain != 0);
//    motorY.enable(steps);
//    while(motorY.remain != 0);
//    motorZ.enable(steps);
//    while(motorZ.remain != 0);
//}



void btInterrupt()    //中断接收函数
{
    if(!bt.readable())
        return;
    char strRe1;                          //定义字符串
    static STATE State = PointerS;        // 初始状态待检查
    strRe1 = bt.getc();                   //读取一个byte数据

    switch(State) {
        case PointerS:
            if (strRe1 == (char)'S') {
                State = PointerW;        //准备跳转至数据选择
                cur = 0;
            } else
                State = PointerS;
            break;
        case PointerW:
            switch (strRe1) {
                case (char)'X':
                    State = PointerX;
                    break;
                case (char)'Y':
                    State = PointerY;
                    break;
                case (char)'Z':
                    State = PointerZ;
                    break;
                case (char)'S':
                    State = PointerS;
                    break;
                case (char)'L':
                    State = PointerL;
                    break;
                case (char)'A':
                    State = PointerA;
                    break;
                case (char)'W':
                    State = PointerWW;
                    break;
                case (char)'P':
                    State = PointerP;
                    break;
                
            }
        //case PointerX:
//            if (strRe1 == (char)'\n') {
//                buf[cur]='\0';
//                pc.printf("%s\n",buf);
//                X = atof(buf+1);
//                State = PointerS;
//                pc.printf("%f\n",X);
//            } else {
//                buf[cur++]=strRe1;
//            }
//            break;
//        case PointerY:
//            if (strRe1 == (char)'\n') {
//                buf[cur]='\0';
//                pc.printf("%s\n",buf);
//                Y = atof(buf+1);
//                State = PointerS;
//                pc.printf("%f\n",Y);
//            } else {
//                buf[cur++]=strRe1;
//            }
//            break;
//        case PointerZ:
//            if (strRe1 == (char)'\n') {
//                buf[cur]='\0';
//                pc.printf("%s\n",buf);
//                Z = atof(buf+1);
//                State = PointerS;
//                pc.printf("%f\n",Z);
//            } else {
//                buf[cur++]=strRe1;
//            }
//            break;
        case PointerX:
            if (strRe1 == (char)'\n') {
                buf[cur]='\0';
                pc.printf("%s\r\n",buf);
                X1 = atof(buf+1);
                State = PointerS;
                pc.printf("%f\r\n",X1);      //32000bu = 360du
                flagx = true;
            } else {
                buf[cur++]=strRe1;
            }
            break;
        case PointerY:
            if (strRe1 == (char)'\n') {
                buf[cur]='\0';
                pc.printf("%s\r\n",buf);
                Y1 = atof(buf+1);
                //Y2 = Y1;
//                Y1 = Y2 - Y1;
                State = PointerS;
                pc.printf("%f\r\n",Y1);
                flagy = true;
            } else {
                buf[cur++]=strRe1;
            }
            break;
        case PointerZ:
            if (strRe1 == (char)'\n') {
                buf[cur]='\0';
                pc.printf("%s\r\n",buf);
                Z = atof(buf+1);
                State = PointerS;
                pc.printf("%f\r\n",Z);
                flagz = true;
            } else {
                buf[cur++]=strRe1;
            }
            break;
        case PointerA:
            if (strRe1 == (char)'\n') {
                buf[cur]='\0';
                pc.printf("%s\n",buf);
                A = atof(buf+1);
                State = PointerS;
                pc.printf("%f\n",A);
            } else {
                buf[cur++]=strRe1;
            }
        case PointerL:
            if (strRe1 == (char)'\n') {
                buf[cur]='\0';
                State = PointerS;
                received = true;
            } else {
                buf[cur++]=strRe1;
            }
            break;
        case PointerWW:
            flagw = true;          
            break; 
        case PointerP:
            flagp = true;
            break;  
    }
}

int main()
{
    pc.printf("Hello World !\r\n");
     motorX.init();
     motorY.init();
     motorZ.init();
    pc.printf("FINISH !\r\n");
    bt.attach(btInterrupt);
//    int i = 1;


    while(1) {
//        btInterrupt();
        //wait(0.1);
        //if (sw.read() == 0)
        //{
        // pc.printf("%s.\r\n", strX);
        // pc.printf("%s.\r\n", strY);
        // pc.printf("%s.\r\n", strZ);
        // pc.printf("%s.\r\n", strA);
        //}
        
        if (flagx)
        {
            float m = (32000*X1)/360;
            motorX.enable((int)(m-remainX));
            remainX = m;
            flagx = false;
        }
        if (flagy)
        {
            float n = (32000*Y1)/360;
            motorY.enable((int)(n-remainY));
            remainY = n;
            flagy = false;
        }
        if (flagz)
        {
            float o = (32000*Z)/360;
            motorZ.enable((int)(o-remainZ));
            remainZ = o;
            flagz = false;
        }
        if (flagw)
        {
            //if (Arr[][] != 
            //{
            pc.printf("Here1!\r\n");  

            pc.printf("Here2!\r\n");    
            motorX.init();
            motorY.init();
            motorZ.init();
            remainX = 0;
            remainY = 0;
            remainZ = 0;

                for (int i = 0;i < counter;i++)
                {
                    motorX.enable(Arr[i][0] - remainX);
                    remainX = Arr[i][0];
                    motorY.enable(Arr[i][1] - remainY);
                    remainY = Arr[i][1];
                    motorZ.enable(Arr[i][2] - remainZ);
                    remainZ = Arr[i][2]; 
                                pc.printf("Here3!\r\n");   
                } 
                  while(!flagp)
        {               flagw = false;
                        pc.printf("Here4!\r\n");
        }  
        }          
        if(received) {
        
            pc.printf("%s\r\n",buf);
            char *p = buf;
            
            float a,x,y,z;
            while(true) {
                p = strchr(p, '(');
                if(!p) break;
                p++;
                sscanf(p, "%f%f%f%f",&x,&y,&z,&a);
                pc.printf("%f %f %f %f\r\n",x,y,z,a);
                Arr[countL][0] = x;
                Arr[countL][1] = y;
                Arr[countL][2] = z;
                Arr[countL][3] = a;
                pc.printf("[%d] %f %f %f %f\r\n",countL,Arr[countL][0],Arr[countL][1],Arr[countL][2],Arr[countL][3]);
                countL++;               
               }
               counter = countL;
               countL = 0;
            received = false;
        }
    }
    return 0;
}