#include "mbed.h"
#include "stepper.h"
#include "SDFileSystem.h"

// mosi, miso, sclk, name
SDFileSystem sd(PB_15, PB_14, PB_13, PB_12, "sd");


typedef enum {
    PointerS,PointerW,PointerX,PointerY,PointerZ,PointerA,PointerL,PointerWW
} STATE;                     //定义结构体枚举类型STATE


Serial pc(PA_9, PA_10);    //定义引脚
Serial bt(PB_10, PB_11);
stepperMotor motorX(PC_5, PC_4, PD_2, PC_8, 0.0002);
stepperMotor motorY(PA_5, PA_4, PA_2, PA_6, 0.0002);
stepperMotor motorZ(PC_3, PC_2, PC_13, PC_6, 0.0002);
//DigitalIn swX(PA_6);
//DigitalIn swY(PA_6);
//DigitalIn swZ(PA_6);
float X , Y , Z , A;              // 定义浮点数值用以储存返回给机械臂的执行步数
const char* strX;                 //定义全局变量X,Y,Z,A字符串指针
const char* strY;
const char* strZ;
const char* strA;
//stringstream ss;
char buf[256];
int cur;
bool received,start;

void init()        //复位函数
{
    stepperMotor motorX(PC_5, PC_4, PD_2, PC_8, 0.0005);
    stepperMotor motorY(PA_5, PA_4, PA_2, PA_6, 0.0005);
    stepperMotor motorZ(PC_3, PC_2, PC_13, PC_6, 0.0005);      //复位速度要变慢
    int steps = -12000;
    motorX.enable(steps);
    while(motorX.remain != 0);
    motorY.enable(steps);
    while(motorY.remain != 0);
    motorZ.enable(steps);
    while(motorZ.remain != 0);
}



void btInterrupt()    //中断接收函数
{
    if(!bt.readable())
        return;
    char strRe1;                          //定义字符串
    static STATE State = PointerS;        // 初始状态待检查
    strRe1 = bt.getc();                   //读取一个byte数据

    switch(State) {
        case PointerS:
            if (strRe1 == (char)'S') {
                State = PointerW;        //准备跳转至数据选择
                cur = 0;
            } else
                State = PointerS;
            break;
        case PointerW:
            switch (strRe1) {
                case (char)'X':
                    State = PointerX;
                    break;
                case (char)'Y':
                    State = PointerY;
                    break;
                case (char)'Z':
                    State = PointerZ;
                    break;
                case (char)'S':
                    State = PointerS;
                    break;
                case (char)'L':
                    State = PointerL;
                    break;
                case (char)'W':
                    State = PointerWW;
                    break;
                case (char)'A':
                    State = PointerA;
                    break;
            }
        case PointerX:
            if (strRe1 == (char)'\n') {
                buf[cur]='\0';
                pc.printf("%s\n",buf);
                X = atof(buf+1);
                State = PointerS;
                pc.printf("%f\n",X);
            } else {
                buf[cur++]=strRe1;
            }
            break;
        case PointerY:
            if (strRe1 == (char)'\n') {
                buf[cur]='\0';
                pc.printf("%s\n",buf);
                Y = atof(buf+1);
                State = PointerS;
                pc.printf("%f\n",Y);
            } else {
                buf[cur++]=strRe1;
            }
            break;
        case PointerZ:
            if (strRe1 == (char)'\n') {
                buf[cur]='\0';
                pc.printf("%s\n",buf);
                Z = atof(buf+1);
                State = PointerS;
                pc.printf("%f\n",Z);
            } else {
                buf[cur++]=strRe1;
            }
            break;
        case PointerA:
            if (strRe1 == (char)'\n') {
                buf[cur]='\0';
                pc.printf("%s\n",buf);
                A = atof(buf+1);
                State = PointerS;
                pc.printf("%f\n",A);
            } else {
                buf[cur++]=strRe1;
            }
        case PointerL:
            if (strRe1 == (char)'\n') {
                buf[cur]='\0';
                State = PointerS;
                received = true;
            } else {
                buf[cur++]=strRe1;
            }
            break;
        case PointerWW:
            if (strRe1 == (char)'\n') {
                State = PointerS;
                start = true;
            } else {
            }
            break;
    }
}

int main()
{

    // motorX.enable();
    // motorY.enable();
    // motorZ.enable();
    // init();
    pc.printf("Hello World !\n");
    bt.attach(btInterrupt);
//    int i = 1;


    while(1) {


        if(received) {
            pc.printf("save %s to file\r\n",buf);

            // 写文件例子
            FILE *fp2 = fopen("/sd/test.txt", "w");
            if (fp2 == NULL)
            {
                printf("open error2!!\r\n");
                return 1;
            }
            fprintf(fp2, "%s", buf);
            fclose(fp2);  //写完文件要记得关闭，不然可能没保存上
            pc.printf("saved\r\n");
            received = false;
        }
        if(start){
         
         
            FILE *fp = fopen("/sd/test.txt", "r"); //打开文件，路径以“/sd/”开头
        
            if (fp == NULL) //打开失败，原因可能是文件不存在，或卡没有连接好
            {
                printf("open error!!\r\n");
                return 1;
            }
            fgets(buf, sizeof(buf), fp); //读入一行的C函数
            pc.printf("read\r\n");
            fclose(fp);  //关闭文件，释放资源
    
            pc.printf("%s\r\n",buf);
            char *p = buf;
            float a,x,y,z;
            while(true) {
                p = strchr(p, '(');
                if(!p) break;
                p++;
                sscanf(p, "%f%f%f%f",&x,&y,&z,&a);
                pc.printf("%f %f %f %f\r\n",x,y,z,a);
            }
            start = false;
        }
    }
    return 0;
}