#include "mbed.h"
/*  En esta practica se muestra la configuracion para el uso de ISR(interrupt serrvice rutine)
    del microcontrolador que usa la FRDM, la practica trata de cambiar el estado del led rgb
    en sus 3 colores diferentes, rojo, verde y azul, en peridos de 1 segundo. Para la demostracion
    se programa una maquina de estados*/
    
Ticker rgb; // se le asigna un identificador a la ISR que se va a utilizar llamado rgb.

DigitalOut rgb_rojo(LED_RED,1); // se configura el led rojo como salida, estado incial apagado
DigitalOut rgb_verde(LED_GREEN,1);// se configura el led verde como salida, estado incial apagado
DigitalOut rgb_azul(LED_BLUE,1);// se configura el led azul como salida, estado incial apagado
int estado_led=1; // variable que se usa en la maquina de estados para el cambio de color del rgb

void blink_rgb(void) // funcion que se llama cada 1 segundo por la ISR
{
    switch(estado_led)
    {
        case 1: 
            rgb_rojo = 0; 
            rgb_verde = 1;
            rgb_azul = 1;
            estado_led = 2; // se cambia el valor de variable a 2
            break;
        case 2:
            rgb_rojo = 1;
            rgb_verde = 0;
            rgb_azul = 1;
            estado_led = 3;// se cambia el valor de variable a 3
            break;
         case 3:
            rgb_rojo = 1;
            rgb_verde = 1;
            rgb_azul = 0;
            estado_led = 1;// se resetea el valor de la variable a 1.
            break; 
        default: // led rgb apagado
            rgb_rojo = 1;
            rgb_verde = 1;
            rgb_azul = 1;
            break;
    }
}

int main() 
{
    rgb.attach(&blink_rgb,1.0);// confiracion de la ISR para que se genere cada 1 segundo indicando la funcion que se ejecutara.
       
    while(1) 
    {
        
    }
}
