#include "mbed.h"

/* En esta practica se muestra el funcionamiento y configuracion basica del 
   conversor digital - analogico(DAC)del micro, la practica consiste en 
   leer el valor de un voltaje de entrada mediante el ADC, y se cree una 
   especie de buffer usando el DAC para que el mismo valor de voltaje de
   entrada sea el de la salida, se muestra el valor de entrada de voltaje
   y salida de voltaje en la terminal de la pc.
   
   No se olvide comprobar la verdadera señal de salida de voltaje con un
   multimetro o osciloscopio.*/
   
AnalogOut voltaje_salida(PTE30); // se inicializa el puerto DAC del microcontrolador para la salida de voltaje
AnalogIn voltaje_entrada(PTB0); // se inicializa el puerto ADC del microcontrolador donde se conecta el potenciometro
Serial pc(USBTX,USBRX); // se inicializa el puerto de comunicacion serie UART del microcontrolador

unsigned int valor_adc; // variable donde se almacena el valor de adc de 16 bits
unsigned int valor_dac; // variable donde se almacena el valor del dac de 16 bits
float voltaje_pot; // variable que se calcula para conocer el valor de voltaje de entrada
float voltaje_dac; // variable que se calcula para conocer el valor de voltaje de salida


int main()
{
    pc.baud(115200);// configuracion del puerto serial para los baudios
    
    while(1) 
    {
        valor_adc = voltaje_entrada.read_u16(); // se lee el valor de voltaje con el ADC 16 bits y se guarda en la variable
        valor_dac = valor_adc; // igualamos el valor del ADC al del DAC
        voltaje_pot = valor_adc * (3.3f / 65535.0f); // se calcula el valor de voltaje de entrada usando el valor de lectura del ADC
        voltaje_dac = valor_dac * (3.3f / 65535.0f); // se calcula el valor de voltaje de salida del DAC
        pc.printf("voltaje de entrada : %.2f, voltaje de salida DAC : %.2f\r\n",voltaje_pot, voltaje_dac); // se imprimen los valores de entrada y salida
        voltaje_salida.write_u16(valor_adc); // se envian los bits de entrada(ADC) al DAC para obtener el mismo voltaje de salida.
        wait_ms(250); // retardo para visualizar en la terminal
    }
}
